%def_disable static

Name: libksba-gost
Version: 1.3.6
Release: alt15

Group: System/Libraries
Summary: X.509 library
URL: http://www.gnupg.org/
License: LGPLv3 / GPLv2

Source0: libksba-%version.tar
Patch1:		libksba-info.patch

# GOST patch
%define gostversion 2.0.0
Patch2: %name-%version-derutil.patch
Patch3: %name-%version-gost-cms.patch
Patch4: %name-%version-pkcs7-gost.patch
#Patch5: %name-%version-pkcs8.patch
Provides: libksba(gost) = %gostversion

Conflicts: libksba

# Automatically added by buildreq on Tue Apr 06 2004 (-bi)
#BuildRequires: gcc-c++ gcc-g77 libgcrypt-devel libgpg-error-devel libstdc++-devel
BuildRequires(pre): rpm-build-ubt
BuildRequires: gcc-c++ libgcrypt-gost-devel libstdc++-devel
BuildRequires: libgpg-error-devel >= 0.6
BuildRequires: texinfo

%description
KSBA is a library designed to build software based
on the X.509 and CMS protocols.

%package -n %name-devel
Summary: Development files for the %name package
Group: Development/Other
Requires: %name = %version-%release
Conflicts: libksba-devel
%description -n %name-devel
Development files for the %name package

%package -n %name-devel-static
Summary: Static libraries for the %name-devel package
Group: Development/Other
Requires: %name-devel = %version-%release
Requires: glibc-devel-static
Conflicts: libksba-devel-static
%description -n %name-devel-static
Static libraries for the %name-devel package

%prep
%setup -q -n libksba-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
#%patch5 -p1

# Rename library: libksba -> libksba-gost.
sed -i \
	-e 's/libksba\(\.la\)/libksba-gost\1/g' \
	-e 's/libksba\(_la\)/libksba_gost\1/g' \
	*/Makefile.am

%build
#__aclocal
#__autoconf
#__automake
./autogen.sh
%configure \
    %{subst_enable static} \
    --enable-ld-version-script
%make_build

%install
%makeinstall
mv %buildroot%_libdir/libksba{-gost,}.so
#rm -fv %buildroot/usr/share/info/dir

%check
%make_build check

%files
%doc AUTHORS NEWS README 
%_libdir/*.so.8
%_libdir/*.so.*

%files -n %name-devel
%doc TODO ChangeLog
%_bindir/*
%prefix/share/aclocal/*
%prefix/include/*.h
#%_libdir/*.la
%_libdir/*.so
%_infodir/*.info*

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%endif

%changelog
