%define _unpackaged_files_terminate_build 1

Name: liblensfun
Version: 0.3.2
Release: alt5.1

Summary: A library to rectifying the defects introduced by your photographic equipment
Group: System/Libraries
License: LGPLv3 and CC-BY-SA-3.0
Url: https://lensfun.github.io

# https://github.com/lensfun/lensfun.git
Source: lensfun-%version.tar
Patch1: lensfun-0.3.2-alt-pkexec.patch

BuildRequires: cmake gcc-c++ glib2-devel libpng-devel
BuildRequires: doxygen rpm-build-python3 python3-module-setuptools python3-module-docutils

%description
A library to rectifying the defects introduced by your photographic equipment.

%package devel
Summary: Development tools for programs which will use the lensfun library
Group: Development/C++
Requires: liblensfun = %EVR

%description devel
Development tools for programs which will use the lensfun library.

%package tools
Summary: Tools for managing lensfun data
Group: Graphics
License: LGPLv3
BuildArch: noarch
Requires: %name = %EVR

%description tools
This package contains tools to fetch lens database, updates and manage lens
adapters in lensfun.

%prep
%setup -n lensfun-%version
%patch1 -p2

%build
%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
%ifnarch %ix86 x86_64
	-DBUILD_FOR_SSE:BOOL=OFF \
	-DBUILD_FOR_SSE2:BOOL=OFF \
%endif
	-DBUILD_TESTS:BOOL=OFF \
	-DBUILD_DOC:BOOL=ON

%cmake_build
%cmake_build -t man

%install
%cmake_install
pushd %_cmake__builddir/apps/
%python3_install
popd

%files
%_libdir/%name.so.*
%_datadir/lensfun/
%doc ChangeLog README.*

%files devel
%_includedir/lensfun/
%_libdir/%name.so
%_pkgconfigdir/lensfun.pc
%doc %_datadir/doc/lensfun*/

%files tools
%_bindir/g-lensfun-update-data
%_bindir/lensfun-add-adapter
%_bindir/lensfun-update-data
%python3_sitelibdir_noarch/*
%_man1dir/*

%changelog
