Name: libmaa
Version: 1.4.7
Release: alt4

Summary: Library providing many low-level data structures
License: MIT
Group: System/Libraries

Url: http://sourceforge.net/projects/dict/
Source: %name-%version.tar
Packager: Aleksey Cheusov <cheusov@altlinux.org>

BuildRequires: mk-configure >= 0.34.2-alt4
BuildRequires: rpm-macros-mk-configure

%description
The libmaa library provides many low-level data
structures, including hash tables, sets, lists, debugging support, and
memory management. Although libmaa was designed and implemented as a
foundation for the kheperalong, the data structures are generally
applicable to a wide range of programming problems.

%package devel
Summary: Development files of libmaa
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files of libmaa.

%package devel-static
Summary: Static library for libmaa
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains the static version of libmaa.

%package devel-doc
Summary: Documentation for libmaa
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
This package contains development documentation for libmaa.

%prep
%setup

%define libmaa_docdir %_docdir/%name-%version
%define _mkc_env \
	export DOCDIR=%libmaa_docdir \
	%mkc_env

%build
%_mkc_env
%mkcmake_configure
%mkcmake_build

%check
%_mkc_env
%mkcmake test

%install
%_mkc_env
%mkcmake_install

%files
%libmaa_docdir/README
%libmaa_docdir/LICENSE
%libmaa_docdir/TODO
%libmaa_docdir/NEWS
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/*

%files devel-doc
%libmaa_docdir/libmaa.600dpi.ps

%files devel-static
%_libdir/*.a

%changelog
