%def_disable snapshot

%define _name libmediaart
%define ver_major 1.9
%define api_ver 2.0
%def_enable introspection
%def_enable gtk_doc
%def_enable check

Name: %_name%api_ver
Version: %ver_major.5
Release: alt1

Summary: Library for handling media art (2.0 API)
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/Tracker

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

Obsoletes: %_name < %version
Provides: %_name = %version-%release

%define meson_ver 0.56.2
%define glib_ver 2.38

BuildRequires: meson >= %meson_ver gcc-c++ libgio-devel >= %glib_ver libgdk-pixbuf-devel zlib-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}
BuildRequires: libvala-devel vala-tools
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
LibMediaArt is a library tasked with managing, extracting and handling
media art caches.

%package devel
Summary: Development files for LibMediaArt
Group: Development/C++
Requires: %name = %version-%release
Obsoletes: %_name-devel < %version
Provides: %_name-devel = %version-%release

%description devel
This package contains libraries and header files needed for
development using LibMediaArt library.

%package gir
Summary: GObject introspection data for the LibMediaArt library
Group: System/Libraries
Requires: %name = %version-%release
Obsoletes: %_name-gir < %version
Provides: %_name-gir = %version-%release

%description gir
GObject introspection data for the LibMediaArt library

%package gir-devel
Summary: GObject introspection devel data for the LibMediaArt library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release
Obsoletes: %_name-gir-devel < %version
Provides: %_name-gir-devel = %version-%release

%description gir-devel
GObject introspection devel data for the LibMediaArt library

%package devel-doc
Summary: Development documentation for LibMediaArt
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version-%release
Obsoletes: %_name-devel-doc < %version
Provides: %_name-devel-doc = %version-%release

%description devel-doc
This package contains development documentation for LibMediaArt library.

%prep
%setup -n %_name-%version
%{?_enable_snapshot:touch ChangeLog}

%build
%meson \
	%{?_enable_gtk_doc:-Dgtk_doc=true} \
	-Dimage_library=gdk-pixbuf
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_libdir/%_name-%api_ver.so.*
%doc NEWS

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.vapi
%_vapidir/%%_name-%api_ver.deps

%if_enabled introspection
%files gir
%_typelibdir/MediaArt-%api_ver.typelib

%files gir-devel
%_girdir/MediaArt-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
