Name: libmediastreamer
Version: 2.16.1
Release: alt5

Group: System/Libraries
Summary: Audio/Video real-time streaming
License: GPLv2+
Url: http://www.linphone.org/eng/documentation/dev/mediastreamer2.html

Requires: %name-common = %version-%release

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: intltool doxygen gcc-c++ libSDL-devel libX11-devel libalsa-devel
BuildRequires: libavcodec-devel libpulseaudio-devel libspeex-devel libspeexdsp-devel
BuildRequires: libswscale-devel libtheora-devel libv4l-devel libgsm-devel
BuildRequires: libXv-devel libjack-devel libsamplerate-devel libglew-devel
BuildRequires: libvpx-devel libortp-devel >= 0.17 vim-common libzrtp-devel
BuildRequires: libsrtp-devel

%description
Mediastreamer2 is a GPL licensed library to make audio and video
real-time streaming and processing. Written in pure C, it is based
upon the oRTP library.

%package common
Summary: Common data for the mediastreamer2 library
Group: Communications
BuildArch: noarch

%description common
Common data for the mediastreamer2 library

%package devel
Summary: Headers, libraries and docs for the mediastreamer2 library
Group: Development/C
Requires: %name = %version-%release
%description devel
Mediastreamer2 is a GPL licensed library to make audio and video
real-time streaming and processing. Written in pure C, it is based
upon the ortp library.

This package contains header files and development libraries needed to
develop programs using the mediastreamer2 library.

%prep
%setup
%patch0 -p1

%build
%define _optlevel 3
%add_optflags %optflags_shared %optflags_strict %optflags_notraceback -fno-schedule-insns -fschedule-insns2
%ifarch %ix86
%add_optflags -malign-double
%endif
%autoreconf
%configure \
    --datadir=%_datadir/mediastreamer \
    --disable-static \
    --disable-documentation \
    --disable-strict \
    --with-srtp \
    --enable-zrtp \
    --enable-shared
%make_build CFLAGS="%optflags" CXXFLAGS="%optflags"

%install
%make install DESTDIR=%buildroot
mkdir -p %buildroot/%_libdir/mediastreamer/plugins

%find_lang mediastreamer

%files -f mediastreamer.lang
%doc AUTHORS ChangeLog NEWS README.md
%dir %_libdir/mediastreamer
%dir %_libdir/mediastreamer/plugins
%_libdir/*.so.*

%files common
%_datadir/mediastreamer

%files devel
# TODO remove if unneeded
#%%doc help/doc/html
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_libdir/mediastreamer
%_includedir/*

%changelog
