%define oname msgpack
Name: libmsgpack
Version: 3.3.0
Release: alt2

Summary: Binary-based efficient object serialization library

License: Boost Software License, Version 1.0
Group: System/Libraries
Url: http://msgpack.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/msgpack/msgpack-c/releases/download/cpp-%version/%oname-%version.tar.gz
Source: %name-%version.tar
Patch: msgpack-3.2.0-alt-fix-vrefbuffer-use-on-ppc64le.patch
# actually poor implementation:
# https://github.com/msgpack/msgpack-c/issues/881
Patch1: msgpack-3.3.0-alt-drop-broken-test.patch

BuildRequires: cmake zlib-devel
BuildRequires: gcc-c++ >= 4.8

# for %%check
BuildRequires: ctest libgtest-devel

Provides: %oname = %version-%release
Obsoletes: %oname

%description
MessagePack is a binary-based efficient object serialization
library. It enables to exchange structured objects between many
languages like JSON. But unlike JSON, it is very fast and small.

%package devel
Summary: Libraries and header files for %name
Group: Development/C++
Requires: %name = %version-%release

Provides: %oname-devel = %version-%release
Obsoletes: %oname-devel

%description devel
Libraries and header files for %name

%prep
%setup
%patch0 -p2
%patch1 -p1
subst "s|/lib|/%_lib|g" CMakeLists.txt

%build
%cmake_insource -DCMAKE_INSTALL_LIBDIR=%_lib -DBUILD_SHARED_LIBS=ON -DMSGPACK_CXX11=ON
%make_build

%check
export LD_LIBRARY_PATH=$(pwd)
%make test

%install
%makeinstall_std

%files
%doc AUTHORS COPYING ChangeLog LICENSE_1_0.txt NOTICE README README.md
%_libdir/*.so.*

%files devel
%_includedir/msgpack.*
%_includedir/msgpack/
%_libdir/*.so
%_pkgconfigdir/msgpack.pc
%_libdir/cmake/msgpack/

%changelog
