Name:    libomniORB
Version: 4.2.4
Release: alt3

Summary: ORB from AT&T (core libraries)

License: LGPL
Group:   Networking/Remote access
URL:     http://omniorb.sourceforge.net/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-url: https://sourceforge.net/projects/omniorb/files/omniORB/omniORB-%{version}/omniORB-%{version}.tar.bz2
Source: %name-%version.tar
Source1: omniORB.cfg
Source2: omninames
Source3: omninames.sysconfig

Patch0: libomniORB-non-strict.patch
Patch1: libomniORB-all-cosifaces.patch
Patch2: libomniORB-ziopdynamic-link.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++ libssl-devel zlib-devel
BuildRequires: python3-dev

%description
omniORB is an Object Request Broker (ORB) that implements the 2.3
specification of the Common Object Request Broker Architecture
(CORBA) [OMG99]. It has passed the Open Group CORBA compliant
testsuite and is one of the three ORBs to have been granted the CORBA
brand in June 1999.

This package contains core libraries need for all omniORB applications.

%package idl
Summary: IDL definitions shipped with omniORB
Group:   Networking/Remote access
BuildArch: noarch
%description idl
This package contains standard IDL definitions shipped with omniORB.
You need this package if you write IDL specification which uses
standard IDL definitions.

%package docs
Summary: Documentations for omniORB
Group:   Networking/Remote access
BuildArch: noarch
%description docs
This package contains documentation for omniORB.

%package COS
Summary: ORB from AT&T (COS service stub and skel libraries)
Group:   Networking/Remote access
Requires: %name = %version-%release
%description COS
This package contains libraries, compiled from auto generated
stub and skel code for COS services.

%package utils
Summary: ORB from AT&T (utilities)
Group:   Networking/Remote access
Requires: %name = %version-%release
%description utils
This package contains utilities for omniORB.

%package names
Summary: NameService implementation for omniORB
Group:   Networking/Remote access
Requires: %name = %version-%release
Requires: %name-COS = %version-%release
%description names
This package contains standard compliant NameService implementation
for omniORB.

%package -n python3-module-omniidl
Summary: Python module for omniidl
Group:   Development/C++
%description -n python3-module-omniidl
This package includes python files for the omniORB package.

%package devel
Summary: development part of omniORB (core definitions and tools)
Group:   Development/C++
Requires: %name = %version-%release
Requires: python3-module-omniidl = %version-%release
%description devel
This devel package includes the libraries and header files
for the omniORB package.

%package devel-COS
Summary: development part of omniORB (COS headers)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-COS
This devel package includes the libraries and header files
for the omniORB package (COS module). You need this package if
you write applications that uses standard services and want
share COS code.

%package devel-static
Summary: development part of omniORB (core static libraries)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-static
This devel package includes static libraries
for the omniORB package.

%package devel-static-COS
Summary: development part of omniORB (COS static libraries)
Group:   Development/C++
Requires: %name-devel = %version-%release
%description devel-static-COS
This devel package includes static libraries
for the omniORB package (COS module).

%prep
%setup
%patch0 -p 1
%patch1 -p 1
%patch2 -p 0

subst "s|AM_PATH_PYTHON|AM_PATH_PYTHON(3.3)|" configure.ac

%build
%autoreconf
%configure \
	--disable-thread-tracing \
	--with-openssl=%_prefix \
	--with-omniORB-config=%_sysconfdir/omniORB.cfg \
	--with-omniNames-logdir=%_logdir/omniORB

# use python3 only
find . -type f -name '*.py' -print0 | xargs -0 %__subst 's|env python|env python3|g'

# FIXME: %make_build
%make EnableZIOP=1

%install
# hasher workaround
unset target ||:
# end

%makeinstall_std EnableZIOP=1

# altlinux specific
# find %buildroot -type f -name '*.py' -print0 | xargs -0 %__subst 's|env python|env python2.7|g'


install -d -m 755 %buildroot%_logdir/omniORB
install -d -m 755 %buildroot%_man1dir
install -d -m 755 %buildroot%_initdir

cp -a man/man1/* %buildroot%_man1dir
install -p -m 644 %SOURCE1 %buildroot%_sysconfdir
install -p -D -m 755 %SOURCE2 %buildroot%_initdir/omninames
install -p -D -m 644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/omninames

%files
%config(noreplace) %_sysconfdir/omniORB.cfg
%_libdir/libomni*.so.*

%files idl
%_datadir/idl/omniORB

%files docs
%doc doc/*.pdf

%files COS
%_libdir/libCOS*.so.*

%files utils
%_bindir/catior
%_bindir/convertior
%_bindir/genior
%_bindir/omniMapper
%_man1dir/catior*
%_man1dir/convertior*
%_man1dir/genior*

%files names
%config(noreplace) %_sysconfdir/sysconfig/omninames
%_initdir/omninames
%_bindir/omniNames
%_bindir/nameclt
%_man1dir/nameclt*
%attr(755,daemon,daemon) %dir %_logdir/omniORB

%files -n python3-module-omniidl
%python3_sitelibdir/*
%python3_sitelibdir_noarch/*

%files devel
%_bindir/omniidl*
%_bindir/omnicpp
%_bindir/omkdepend
%_includedir/omniORB4
%_includedir/omniconfig.h
%_includedir/omnithread
%_includedir/omnithread.h
%_libdir/libomni*.so
%_libdir/pkgconfig/omniORB*
%_libdir/pkgconfig/omniDynamic*
%_libdir/pkgconfig/omnithread*
%_libdir/pkgconfig/omniConnectionMgmt*
%_libdir/pkgconfig/omniZIOP*
%_man1dir/omniidl*
%_man1dir/omnicpp*

%files devel-COS
%_includedir/COS
%_libdir/libCOS*.so
%_libdir/pkgconfig/omniCOS*

%files devel-static
%_libdir/libomni*.a

%files devel-static-COS
%_libdir/libCOS*.a

%changelog
