%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_without openimageio

# TODO: build docs

%define oname opencolorio
%define soname 2.0

Name:           lib%oname%soname
Version:        2.0.2
Release:        alt0.p10.1
Summary:        Enables color transforms and image display across graphics apps
Group:          System/Libraries

License:        BSD
URL:            https://opencolorio.org/

# https://github.com/imageworks/OpenColorIO.git
Source:         %name-%version.tar

Patch1: opencolorio-alt-install.patch
Patch2: opencolorio-alt-armh-multiple-definition.patch

# Utilities
BuildRequires: cmake gcc-c++
BuildRequires: help2man

# WARNING: OpenColorIO and OpenImageIO are cross dependent.
# If an ABI incompatible update is done in one, the other also needs to be
# rebuilt.
%if_with openimageio
BuildRequires: libopenimageio-devel
%endif
BuildRequires: openexr-devel

# Libraries
BuildRequires: libGL-devel libGLU-devel
BuildRequires: libX11-devel libXmu-devel libXi-devel
BuildRequires: libfreeglut-devel
BuildRequires: libGLEW-devel
BuildRequires: zlib-devel
BuildRequires: libexpat-devel
BuildRequires: pystring-devel
BuildRequires: pybind11-devel
BuildRequires: python3-devel
BuildRequires: liblcms2-devel
BuildRequires: libyaml-cpp-devel
BuildRequires: boost-devel

# Test dependencies
BuildRequires: ctest
BuildRequires: python3-module-numpy

%description
OCIO enables color transforms and image display to be handled in a consistent
manner across multiple graphics applications. Unlike other color management
solutions, OCIO is geared towards motion-picture post production, with an
emphasis on visual effects and animation color pipelines.

%package -n %oname%soname-tools
Summary:        Command line tools for %oname
Group:          Other
Requires:       lib%oname%soname = %EVR

%description -n %oname%soname-tools
Command line tools for %oname.

%package devel
Summary:        Development libraries and headers for %oname
Group:          Development/Other
Requires:       lib%oname%soname = %EVR

%description devel
Development libraries and headers for %oname.

%package -n python3-module-%oname
Summary:        %oname python3 module
Group:          Development/Python3

%description -n python3-module-%oname
%oname python3 module.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

# disable debugging wrappers
%add_optflags -DNDEBUG

%ifarch %e2k
%add_optflags -std=c++11
%endif

%cmake \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DOCIO_BUILD_PYTHON:BOOL=ON \
	-DOCIO_BUILD_STATIC=OFF \
	-DOCIO_BUILD_DOCS=OFF \
	-DOCIO_BUILD_TESTS=ON \
	-DOCIO_BUILD_GPU_TESTS=OFF \
	-DOCIO_WARNING_AS_ERROR:BOOL=OFF \
%ifnarch x86_64 %e2k
	-DOCIO_USE_SSE=OFF \
%endif
%ifnarch %e2k
	-DOCIO_USE_GLVND:BOOL=ON \
	-DOpenGL_GL_PREFERENCE=GLVND \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

# Generate man pages
mkdir -p %buildroot%_man1dir

for i in %buildroot%_bindir/* ; do
	if [ "$(basename $i)" != "ociodisplay" ] ; then
		LD_LIBRARY_PATH=%buildroot%_libdir \
		help2man -N -s 1 --version-string=%version \
		-o %buildroot%_man1dir/$(basename $i).1 \
		$i
	fi
done

%check
pushd %_cmake__builddir
# currently tests only pass on x86_64 and armh
# on other architectures there are precision issues
%ifarch x86_64 %arm
ctest
%else
ctest ||:
%endif
popd

%files -n lib%oname%soname
%doc LICENSE THIRD-PARTY.md
%doc CHANGELOG.md CONTRIBUTING.md COMMITTERS.md GOVERNANCE.md PROCESS.md README.md SECURITY.md
%_libdir/*.so.%{soname}
%_libdir/*.so.%{soname}.*

%files -n %oname%soname-tools
%_bindir/*
%_man1dir/*

%files devel
%_includedir/OpenColorIO/
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/OpenColorIO/

%files -n python3-module-%oname
%python3_sitelibdir/*.so

%changelog
