
Summary: A library for managing OS information for virtualization
Name: libosinfo
Version: 1.10.0
Release: alt1

License: LGPLv2+
Group: System/Libraries

Source: %name-%version.tar
#Patch2: %name-%version-altlinux.patch

Url: https://libosinfo.org
BuildRequires(pre): meson >= 0.49.0
BuildRequires: gettext >= 0.19.8
BuildRequires: gtk-doc
BuildRequires: pkgconfig(glib-2.0) >= 2.44 pkgconfig(gobject-2.0) pkgconfig(gio-2.0)
BuildRequires: pkgconfig(libsoup-2.4)
BuildRequires: pkgconfig(libxml-2.0) >= 2.6.0
BuildRequires: pkgconfig(libxslt) >= 1.0.0
BuildRequires: gobject-introspection-devel >= 0.9.7
BuildRequires: perl-podlators
BuildRequires: vala
BuildRequires: vala-tools
BuildRequires: pciids usbids
BuildRequires: osinfo-db

Requires: pciids usbids
Requires: osinfo-db osinfo-db-tools

%description
libosinfo is a library that allows virtualization provisioning tools to
determine the optimal device settings for a hypervisor/operating system
combination.

%package devel
Summary: Libraries, includes, etc. to compile with the libosinfo library
Group: Development/Other
Requires: %name = %version-%release

%description devel
libosinfo is a library that allows virtualization provisioning tools to
determine the optimal device settings for a hypervisor/operating system
combination.

Libraries, includes, etc. to compile with the libosinfo library

%package gir
Summary: GObject introspection data for the libosinfo library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the libosinfo library

%package gir-devel
Summary: GObject introspection devel data for the libosinfo library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the libosinfo library

%package devel-doc
Summary: Development package for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Contains developer documentation for %name.


%prep
%setup
#%%patch2 -p1

%build
%meson \
    -Denable-gtk-doc=true \
    -Denable-tests=true \
    -Dwith-usb-ids-path=%_datadir/misc/usb.ids \
    -Dwith-pci-ids-path=%_datadir/misc/pci.ids \
    -Denable-introspection=enabled \
    -Denable-vala=enabled

%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
export LD_LIBRARY_PATH=$(pwd)/%{__builddir}/osinfo
%meson_test

%files -f %name.lang
%doc COPYING.LIB NEWS README
%_bindir/*
%_man1dir/*
%_libdir/%name-*.so.*

%files devel
%_libdir/%name-*.so
%dir %_includedir/%name-1.0
%dir %_includedir/%name-1.0/osinfo
%_includedir/%name-1.0/osinfo/*.h
%_pkgconfigdir/%name-*.pc
%_datadir/vala/vapi/*

%files gir
%_libdir/girepository-1.0/*.typelib

%files gir-devel
%_datadir/gir-1.0/*.gir

%files devel-doc
%_datadir/gtk-doc/html/*

%changelog
