%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name pango
%define ver_major 1.48
%define api_ver 1.0
%define module_ver 1.8.0
%def_disable static
%def_enable docs
%def_enable introspection
%def_disable installed_tests
%def_enable xft
%def_enable fontconfig
%def_enable freetype
%def_enable cairo
%def_enable libthai
%def_disable sysprof
%def_enable check

Name: lib%_name
Version: %ver_major.11
Release: alt1

Summary: System for layout and rendering of internationalized text
License: LGPL-2.1-or-later
Group: System/Libraries
Url: https://www.pango.org/

%if_disabled snapshot
Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
%else
Vcs: https://gitlab.gnome.org/GNOME/pango.git
Source: %_name-%version.tar
%endif

Source10: pango-compat.map
Source11: pango-compat.lds
Source12: pangoft2-compat.map
Source13: pangoft2-compat.lds
Source14: pangocairo-compat.map
Source15: pangocairo-compat.lds

Patch: pango-1.45.1-alt-compat-version-script.patch

Provides: %_name = %version
Obsoletes: %_name < %version
Obsoletes: gscript

# from meson.build
%define meson_ver 0.55.3
%define glib_ver 2.62
%define cairo_ver 1.12.10
%define gi_docgen_ver 2021.3
%define xft_ver 2.0.0
%define fontconfig_ver 2.11.91
%define freetype_ver 2.1.4
%define gi_ver 0.9.5
%define hb_ver 2.2.0
%define thai_ver 0.1.9
%define fribidi_ver 1.0.6

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson >= %meson_ver gcc-c++
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libharfbuzz-devel >= %hb_ver
BuildRequires: libfribidi-devel >= %fribidi_ver
BuildRequires: help2man /proc
%{?_enable_xft:BuildRequires: libXft-devel >= %xft_ver}
%{?_enable_fontconfig:BuildRequires: fontconfig-devel >= %fontconfig_ver}
%{?_enable_freetype:BuildRequires: libfreetype-devel >= %freetype_ver}
%{?_enable_cairo:BuildRequires: libcairo-devel >= %cairo_ver libcairo-gobject-devel}
%{?_enable_libthai:BuildRequires: libthai-devel >= %thai_ver}
# since 1.48.3 gi-docgen used
%{?_enable_docs:BuildRequires: gi-docgen >= %gi_docgen_ver}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver libharfbuzz-gir-devel}
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_check:BuildRequires: fonts-otf-abattis-cantarell fonts-otf-adobe-source-sans-pro
BuildRequires: fonts-ttf-google-droid-sans fonts-ttf-thai-scalable-waree}

%description
A library to handle unicode strings as well as complex bidirectional
or context dependent shaped strings.

%package devel
Summary: Development libraries and header files for pango
Group: Development/C
Provides: %_name-devel = %version
Obsoletes: %_name-devel < %version
Requires: %name = %version-%release

%description devel
The pango-devel package includes the libraries and header files
for the pango package.

%package devel-doc
Summary: Development documentation for Pango
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Pango is a library to handle unicode strings as well as complex
bidirectional or context dependent shaped strings.

This package contains development documentation for Pango.

%if_enabled static
%package devel-static
Summary: Static libraries for pango
Group: Development/C

%description devel-static
The pango-devel package includes the static libraries for the pango package.
%endif

%package gir
Summary: GObject introspection data for the Pango library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Pango library

%package gir-devel
Summary: GObject introspection devel data for the Pango library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Pango library

%package tests
Summary: Tests for the Pango library
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Pango library.

%prep
%setup -n %_name-%version
%patch -p1 -b .vs
install -p -m644 %_sourcedir/pango{,ft2,cairo}-compat.{map,lds} pango/

%build
%meson \
    %{?_disable_xft:-Dxft=disabled} \
    %{?_disable_fontconfig:-Dfontconfig=disabled} \
    %{?_disable_freetype:-Dfreetype=disabled} \
    %{?_disable_cairo:-Dcairo=disabled} \
    %{?_disable_libthai:-Dlibthai=disabled} \
    %{?_disable_introspection:-Dintrospection=disabled} \
    %{?_enable_docs:-Dgtk_doc=true} \
    %{?_enable_installed_tests:-Dinstall-tests=true} \
    %{?_enable_sysprof:-Dsysprof=enabled}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_bindir/%_name-list
%_bindir/%_name-view
%{?_enable_cairo:%_bindir/%_name-segmentation}
%_libdir/%name-%api_ver.so.*
%_libdir/%{name}cairo-%api_ver.so.*
%_libdir/%{name}ft2-%api_ver.so.*
%_libdir/%{name}xft-%api_ver.so.*
%_man1dir/%_name-view.*
%doc NEWS README*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files gir
%_typelibdir/Pango-%api_ver.typelib
%_typelibdir/PangoCairo-%api_ver.typelib
%_typelibdir/PangoFc-%api_ver.typelib
%_typelibdir/PangoFT2-%api_ver.typelib
%_typelibdir/PangoOT-%api_ver.typelib
%_typelibdir/PangoXft-%api_ver.typelib

%files gir-devel
%_girdir/*.gir
%endif

%if_enabled docs
%files devel-doc
#%_datadir/gtk-doc/html/*
%dir %_datadir/doc/%_name
%_datadir/doc/%_name/reference/
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/%_name/%module_ver/*/*.a
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
