%def_disable bootstrap
%def_disable builtin

Name: libpsl
Version: 0.21.5
Release: alt1

Summary: C library for the Public Suffix List
License: MIT
Group: System/Libraries
URL: https://github.com/rockdaboot/libpsl
Vcs: https://github.com/rockdaboot/libpsl.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-python3
%if_disabled bootstrap
BuildRequires(pre): meson
BuildRequires: glib2-devel libgio-devel
%{?_enable_builtin:BuildRequires: libicu-devel}
BuildRequires: libidn2-devel
BuildRequires: libunistring-devel
BuildRequires: gtk-doc xsltproc
BuildRequires: publicsuffix-list
BuildRequires: publicsuffix-list-dafsa
%endif

Requires: publicsuffix-list-dafsa

%define _unpackaged_files_terminate_build 1

%description
libpsl is a C library to handle the Public Suffix List. A "public suffix" is a
domain name under which Internet users can directly register own names.

Browsers and other web clients can use it to

- Avoid privacy-leaking "supercookies";
- Avoid privacy-leaking "super domain" certificates;
- Domain highlighting parts of the domain in a user interface;
- Sorting domain lists by site;

Libpsl...

- allows to load PSL data from files;
- checks if a given domain is a "public suffix";
- provides immediate cookie domain verification;
- finds the longest public part of a given domain;
- finds the shortest private part of a given domain;
- works with international domains (UTF-8 and IDNA2008 Punycode);
- is thread-safe;
- handles IDNA2008 UTS#46;

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: publicsuffix-list

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: This package contains development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: %name-devel = %version-%release

%description devel-doc
This package contains development documentation for %name

%package -n psl
Group: Networking/DNS
Summary: Commandline utility to explore the Public Suffix List

%description -n psl
This package contains a commandline utility to explore the Public Suffix List,
for example it checks if domains are public suffixes, checks if cookie-domain
is acceptable for domains and so on.

%package -n psl-make-dafsa
Group: Networking/DNS
Summary: Compiles the Public Suffix List into DAFSA form
BuildArch: noarch

%description -n psl-make-dafsa
This script produces C/C++ code or an architecture-independent binary object
which represents a Deterministic Acyclic Finite State Automaton (DAFSA)
from a plain text Public Suffix List.

%prep
%setup
%patch -p1

%if_disabled bootstrap
%build
%meson \
	-Druntime=libidn2 \
%if_enabled builtin
	-Dbuiltin=true \
%else
	-Dbuiltin=false \
%endif
	-Dpsl_distfile=%_datadir/publicsuffix/public_suffix_list.dafsa \
	-Dpsl_file=%_datadir/publicsuffix/effective_tld_names.dat \
	-Dpsl_testfile=%_datadir/publicsuffix/test_psl.txt \
    -Ddocs=true \
    -Dtests=true

%meson_build -v

%install
%meson_install
%else # bootstrap
install -Dm0755 src/psl-make-dafsa %buildroot%_bindir/psl-make-dafsa
install -Dm0644 src/psl-make-dafsa.1 %buildroot%_man1dir/psl-make-dafsa.1
%endif # bootstrap

%if_disabled bootstrap
%check
%meson_test

%files
%doc COPYING
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_man3dir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%files -n psl
%doc AUTHORS NEWS COPYING
%_bindir/psl
%_man1dir/psl.1*
%endif # bootstrap

%files -n psl-make-dafsa
%doc COPYING
%_bindir/psl-make-dafsa
%_man1dir/psl-make-dafsa.1*

%changelog
