%define _unpackaged_files_terminate_build 1

Name: libselinux
Epoch: 1
Version: 3.2
Release: alt1
Summary: SELinux library
License: Public Domain
Group: System/Libraries
Url: https://github.com/SELinuxProject/selinux/wiki

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libpcre-devel
BuildRequires: python3-devel
BuildRequires: swig >= 3.0.12-alt4
BuildRequires: libsepol-devel >= %version
BuildRequires: libsepol-devel-static >= %version

%description
libselinux provides an API for SELinux applications to get and set
process and file security contexts and to obtain security policy
decisions.

%package devel
Summary: SELinux development library and header files
Group: Development/C
Requires: %name = %EVR

%description devel
This package contains development library and header files needed
for developing SELinux applications.

%package devel-static
Summary: Static SELinux library
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package contains static SELinux library needed for developing
statically linked SELinux applications.

%package utils
Summary: SELinux utilities
Group: System/Configuration/Other
Requires: %name = %EVR

%description utils
This package provides utility programs to get and set process and
file security contexts and to obtain security policy decisions.

%package -n python3-module-selinux
Summary: Python 3.x module for %name
Group: System/Configuration/Other
Requires: %name = %EVR

%description -n python3-module-selinux
This package contains SELinux python 3.x bindings.

%prep
%setup
%patch0 -p1

%build
%make_build CFLAGS="%optflags $(pkg-config libpcre --cflags)" LIBDIR=%_libdir all
%make_build CFLAGS="%optflags" LIBDIR=%_libdir PYTHON=%_bindir/python3 pywrap

%install
%makeinstall_std LIBDIR=%_libdir SHLIBDIR=/%_lib LIBSEPOLA=%_libdir/libsepol.a PYTHON=/usr/bin/python3 install-pywrap
install -d -m 0755 %buildroot%_runtimedir/setrans

mv %buildroot%_sbindir/getdefaultcon %buildroot%_sbindir/selinuxdefcon
mv %buildroot%_sbindir/getconlist %buildroot%_sbindir/selinuxconlist

%find_lang --with-man --all-name %name

egrep -v 'booleans\.8|selinux\.8' %name.lang > %name-utils.lang
egrep    'booleans\.8|selinux\.8' %name.lang > %name-files.lang

%check
# Some vital PAM modules are linked with libselinux and therefore
# we cannot allow libselinux to be linked with libpthread.
if ldd -r %buildroot%_libdir/libselinux.so 2>&1 |grep -Fq libpthread; then
	echo >&2 'ERROR: libselinux pulls in libpthread.'
	exit 1
fi

%files -f %name-files.lang
/%_lib/*.so.*
%_man8dir/booleans.*
%_man8dir/selinux.*
%dir %_runtimedir/setrans

%files devel
%_libdir/*.so
%_includedir/selinux
%_pkgconfigdir/*
%_man3dir/*

%files devel-static
%_libdir/*.a

%files utils -f %name-utils.lang
%_sbindir/*
%_man5dir/*
%_man8dir/*
%exclude %_man8dir/booleans.*
%exclude %_man8dir/selinux.*

%files -n python3-module-selinux
%python3_sitelibdir/*

%changelog
