# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name: libsodium
Summary: A modern, portable, easy to use crypto library
Version: 1.0.18
Release: alt1
License: ISC
Group: System/Libraries
Url: https://libsodium.org/
# 'stable' branch is recommended.
Vcs: https://github.com/jedisct1/libsodium
# Docs: https://doc.libsodium.org/
# Docs vcs: https://github.com/jedisct1/libsodium-doc

Source: %name-%version.tar

%description
Sodium is a new, easy-to-use software library for encryption, decryption,
signatures, password hashing and more.

It is a portable, cross-compilable, installable, packageable fork of
NaCl, with a compatible API, and an extended API to improve usability
even further.

Its goal is to provide all of the core operations needed to build
higher-level cryptographic tools.

The design choices emphasize security and ease of use. But despite the
emphasis on high security, primitives are faster across-the-board than
most implementations.

%package -n libsodium23
Summary: %summary
Group: System/Libraries

%description -n libsodium23
%summary.

%package devel
Summary: Development files for libsodium
Group: Development/C

%description devel
%summary.

%package devel-static
Summary: Development files for libsodium
Group: Development/C
Requires: %name-devel

%description devel-static
%summary.

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall

%check
%make_build check

%files devel
%doc AUTHORS LICENSE README.markdown THANKS
%_libdir/libsodium.so
%_libdir/pkgconfig/libsodium.pc
%_includedir/sodium.h
%_includedir/sodium

%files devel-static
%_libdir/libsodium.a

%files -n libsodium23
%_libdir/libsodium.so.23*

%changelog
