# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(fftw3f)
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
%define oldname speexdsp
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libspeexdsp
Version:        1.2.0
Release:        alt1_1
Summary:        A voice compression format (DSP)

License:        BSD
URL:            http://www.speex.org/
Source0:        http://downloads.xiph.org/releases/speex/%{oldname}-%{version}.tar.gz

BuildRequires:  gcc
# speexdsp was split from speex in 1.2rc2. As speexdsp does not depend on
# speex, a versioned conflict is required.
Conflicts: libspeex <= 1.2-0.21.rc1
Source44: import.info
Provides: speexdsp = %{version}-%{release}
Conflicts: libspeex < 1.2-alt0.6

%description
Speex is a patent-free compression format designed especially for
speech. It is specialized for voice communications at low bit-rates in
the 2-45 kbps range. Possible applications include Voice over IP
(VoIP), Internet audio streaming, audio books, and archiving of speech
data (e.g. voice mail).

This is the DSP package, see the speex package for the codec part.

%package devel
Group: Development/Other
Summary: 	Development package for %{oldname}
Requires: 	%{name} = %{version}-%{release}
# speexdsp was split from speex in 1.2rc2. As speexdsp does not depend on
# speex, a versioned conflict is required.
Conflicts: libspeex-devel <= 1.2-0.21.rc1
Provides: speexdsp-devel = %{version}-%{release}
Conflicts: libspeex-devel < 1.2-alt0.6

%description devel
Speex is a patent-free compression format designed especially for
speech. This package contains development files for %{oldname}

This is the DSP package, see the speex package for the codec part.


%prep
%setup -n %{oldname}-%{version} -q


%build
%configure \
%ifarch aarch64
	--disable-neon \
%endif
	--disable-static

%make_build

%install
%makeinstall_std

# Remove libtool archives
find %{buildroot} -type f -name "*.la" -delete




%files
%doc AUTHORS COPYING TODO ChangeLog README NEWS doc/manual.pdf
%doc %{_docdir}/speexdsp/manual.pdf
%{_libdir}/libspeexdsp.so.*

%files devel
%{_includedir}/speex
%{_libdir}/pkgconfig/speexdsp.pc
%{_libdir}/libspeexdsp.so

%changelog
