%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define _name spice-gtk
%def_enable introspection
%def_with sasl
%def_enable vala
%def_enable smartcard
%def_enable usbredir
%def_enable webdav
%def_enable lz4
%def_enable gtk_doc
%def_enable epoxy
%def_enable libva

Name: libspice-gtk
Version: 0.39
Release: alt1
Summary: A GTK widget for SPICE clients

Group: System/Libraries
License: LGPLv2+
Url: http://spice-space.org/page/Spice-Gtk
# VCS-git: https://gitlab.freedesktop.org/spice/spice-gtk.git
Source: %name-%version.tar
Source2: spice-common.tar
Source3: keycodemapdb.tar
Source4: spice-common-recorder.tar
# Patch: %name-%version-%release.patch
# Patch2: %name-alt-fix.patch

%define vala_ver 0.14

Requires: libspice-glib = %version-%release

BuildRequires(pre): meson >= 0.53
BuildRequires: gcc-c++ gtk-doc intltool
BuildRequires: libjpeg-devel libpixman-devel >= 0.17.7 libssl-devel zlib-devel
BuildRequires: spice-protocol >= 0.14.3
BuildRequires: glib2-devel >= 2.52 libgio-devel >= 2.36 libcairo-devel >= 1.2.0
BuildRequires: libjson-glib-devel
BuildRequires: libopus-devel >= 0.9.14
%{?_enable_webdav:BuildRequires: libphodav-devel >= 2.0 glib2-devel >= 2.43.90 libsoup-devel >= 2.49.91}
%{?_with_sasl:BuildRequires: libsasl2-devel}
%{?_enable_vala:BuildRequires: libvala-devel >= %vala_ver vala >= %vala_ver vala-tools}
%{?_enable_smartcard:BuildRequires: libcacard-devel >= 2.5.1}
%{?_enable_usbredir:BuildRequires: libgudev-devel libusb-devel >= 1.0.21 libusbredir-devel >= 0.7.1}
%{?_enable_lz4:BuildRequires: liblz4-devel}
BuildRequires: libpolkit-devel >= 0.101 libacl-devel libcap-ng-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libgstreamer1.0-gir-devel}
BuildRequires: libgtk+3-devel >= 3.22
BuildRequires: wayland-protocols >= 1.17 wayland-devel libwayland-server-devel libwayland-cursor-devel libwayland-client-devel
%{?_enable_libva:BuildRequires: libva-devel}
%{?_enable_epoxy:BuildRequires: libepoxy-devel libdrm-devel}
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel gstreamer1.0-utils gst-plugins-base1.0 gst-plugins-good1.0
BuildRequires: gst-plugins-bad1.0 gst-libav
BuildRequires: perl-Text-CSV perl-Text-CSV_XS python3-module-pyparsing python3-module-six
BuildRequires: /usr/bin/pod2man

%description
A Gtk client and libraries for SPICE remote desktop servers.

%package devel-doc
Summary: Development docs package for spice-gtk libraries
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
Development docs package for spice-gtk libraries

%package -n libspice-glib
Summary: A GObject for communicating with Spice servers
Group: System/Libraries

%description -n libspice-glib
spice-client-glib-2.0 is a SPICE client library for GLib2.

%package -n libspice-glib-devel
Summary: Development files to build Glib2 applications with spice-glib-2.0
Group: Development/C
Requires: libspice-glib = %version-%release

%description -n libspice-glib-devel
spice-client-glib-2.0 is a SPICE client library for GLib2.

Libraries, includes, etc. to compile with the spice-glib-2.0 libraries

%package -n libspice-gtk3
Summary: A GTK3 widget for SPICE clients
Group: System/Libraries
Requires: libspice-glib = %version-%release

%description -n libspice-gtk3
spice-client-glib-3.0 is a SPICE client library for Gtk3.

%package -n libspice-gtk3-devel
Summary: Development files to build GTK3 applications with spice-gtk-3.0
Group: Development/GNOME and GTK+
Requires: libspice-gtk3 = %version-%release
Requires: libspice-glib-devel = %version-%release

%description -n libspice-gtk3-devel
spice-client-gtk-3.0 provides a SPICE viewer widget for GTK3.

Libraries, includes, etc. to compile with the spice-gtk3 libraries

%package -n libspice-glib-gir
Summary: GObject introspection data for the spice-glib-2.0 library
Group: System/Libraries
Requires: libspice-glib = %version-%release

%description -n libspice-glib-gir
GObject introspection data for the spice-glib-2.0 library

%package -n libspice-glib-gir-devel
Summary: GObject introspection devel data for the spice-glib-2.0 library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libspice-glib-gir = %version-%release
Requires: libspice-glib-devel = %version-%release

%description -n libspice-glib-gir-devel
GObject introspection devel data for the spice-glib-2.0 library


%package -n libspice-gtk3-gir
Summary: GObject introspection data for the spice-gtk library
Group: System/Libraries
Requires: libspice-gtk3 = %version-%release
Requires: libspice-glib-gir = %version-%release

%description -n libspice-gtk3-gir
GObject introspection data for the spice-gtk library

%package -n libspice-gtk3-gir-devel
Summary: GObject introspection devel data for the spice-gtk library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libspice-gtk3-gir = %version-%release
Requires: libspice-glib-gir-devel = %version-%release

%description -n libspice-gtk3-gir-devel
GObject introspection devel data for the spice-gtk library

%package tools
Summary: Spice-gtk tools
Group: Networking/Remote access
Requires: libspice-gtk3 = %version-%release

%description tools
Provides useful utilities for interacting with
SPICE servers. Includes snappy, a program for capturing
screen-shots of a SPICE desktop

%prep
%setup
tar -xf %SOURCE2 -C subprojects/spice-common
tar -xf %SOURCE3 -C subprojects/keycodemapdb
tar -xf %SOURCE4 -C subprojects/spice-common/common/recorder

# %patch -p1
# %patch2 -p1
echo "%version" > .tarball-version

%build
%meson \
        %{?_enable_webdav:-Dwebdav=enabled} \
        %{?_enable_gstvideo:-Dgstvideo=enabled} \
        %{?_enable_usbredir:-Dusbredir=enabled} \
        -Dcoroutine=gthread \
        %{?_enable_introspection:-Dintrospection=enabled} \
        %{?_enable_vala:-Dvapi=enabled} \
        %{?_enable_lz4:-Dlz4=enabled} \
        %{?_with_sasl:-Dsasl=enabled} \
        %{?_enable_smartcard:-Dsmartcard=enabled -Dspice-common:smartcard=enabled} \
        %{?_disable_gtk_doc:-Dgtk_doc=disabled} \
        -Dgtk=enabled \
	-Dwayland-protocols=enabled \
        -Dpolkit=enabled \
	-Dlibcap-ng=enabled \
        -Dusb-acl-helper-dir=%_libexecdir/spice-gtk \
        -Dusb-ids-path=%_datadir/misc \
        -Dpie=true

%meson_build

%install
%meson_install

%find_lang %_name

%files -n libspice-gtk3
%_libdir/libspice-client-gtk-3.0.so.*

%files -n libspice-gtk3-devel
%_libdir/libspice-client-gtk-3.0.so
%_includedir/spice-client-gtk-3.0
%_pkgconfigdir/spice-client-gtk-3.0.pc
%_datadir/vala/vapi/spice-client-gtk-3.0.*

%files -n libspice-glib  -f %_name.lang
%_libdir/libspice-client-glib-2.0.so.*
%_libexecdir/spice-gtk/spice-client-glib-usb-acl-helper
%_datadir/polkit-1/actions/org.spice-space.lowlevelusbaccess.policy

%files -n libspice-glib-devel
%_libdir/libspice-client-glib-2.0.so
%_includedir/spice-client-glib-2.0
%_pkgconfigdir/spice-client-glib-2.0.pc
%_datadir/vala/vapi/spice-client-glib-2.0.vapi
%_datadir/vala/vapi/spice-client-glib-2.0.deps

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%files tools
%_bindir/*
%_man1dir/*.1*

%if_enabled introspection
%files -n libspice-glib-gir
%_typelibdir/SpiceClientGLib-2.0.typelib

%files -n libspice-glib-gir-devel
%_girdir/SpiceClientGLib-2.0.gir

%files -n libspice-gtk3-gir
%_typelibdir/SpiceClientGtk-3.0.typelib

%files -n libspice-gtk3-gir-devel
%_girdir/SpiceClientGtk-3.0.gir

%endif

%changelog
