%define _unpackaged_files_terminate_build 1

%def_disable gcrypt
%define sover 4
#%define libssh libssh%sover
# uncomment previous line and remove next line when  sover != 4
%define libssh libssh

Name: libssh
Version: 0.10.6
Release: alt1

Group: System/Libraries
Summary: C library to authenticate in a simple manner to one or more SSH servers
Url: http://www.libssh.org/
License: LGPL-2.1-or-later

# svn checkout svn://svn.berlios.de/libssh/trunk libssh
Source: http://www.libssh.org/files/%name-%version.tar.gz
Source3: libssh_client.config
Source4: libssh_server.config
# FC
Patch1: libssh-0.10.6-rekey-timeout.patch
Patch2: libssh-0.10.6-ipv6-hostname.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++ %{?_enable_gcrypt: libgcrypt-devel}
BuildRequires: libssl-devel zlib-devel
BuildRequires: libkrb5-devel

%description
The ssh library was designed to be used by programmers needing a working
SSH implementation by the mean of a library. The complete control of the
client is made by the programmer. With libssh, you can remotely execute
programs, transfer files, use a secure and transparent tunnel for your
remote programs. With its Secure FTP implementation, you can play with
remote files easily, without third-party programs others than libcrypto
(from openssl). libssh features :

    * Full C library functions for manipulating a client-side SSH
      connection
    * Lesser GPL licensing -SSH2 protocol compliant
    * Fully configurable sessions
    * Support for AES-128,AES-192,AES-256,blowfish, in cbc mode
    * Use multiple SSH connections in a same process, at same time
    * Use multiple channels in the same connection
    * Thread safety when using different sessions at same time
    * Basic but correct SFTP implementation (secure file transfer)
    * RSA and DSS server public key supported
    * Compression support (with zlib)
    * Public key (RSA and DSS), password and keyboard-interactive
      authentication
    * Complete documentation about its API
    * Runs and tested under amd64, x86, arm, sparc32, ppc under Linux,
      BSD, MacosX and Solaris
    * A developer listening to you
    * It's free (LGPL)!

%if "%sover" != "4"
%package -n %libssh
Summary: Development files for %name
Group: System/Libraries
%description -n %libssh
%{description}
%endif

%package devel
Summary: Development files for %name
Group: System/Libraries
Requires: %name = %version-%release
Provides: ssh-devel = %version-%release
%description devel
This package contains the development files for %name.


%prep
%setup -q
%patch1 -p1
%patch2 -p1
find ./ -type f \( -name *.c -or -name *.h \) | \
while read f; do
    sed -i -E '/^#define[[:space:]]+KEYS_FOLDER[[:space:]]+"\/etc\/ssh\/"/s/\/etc\/ssh\//\/etc\/openssh/' "$f"
done

%build
%cmake \
    -DWITH_ZLIB=ON \
    -DWITH_GSSAPI=ON \
    -DWITH_GCRYPT=%{?_enable_gcrypt:ON}%{!?_enable_gcrypt:OFF} \
    -DGLOBAL_CLIENT_CONFIG="%_sysconfdir/libssh/libssh_client.config" \
    -DGLOBAL_BIND_CONFIG="%_sysconfdir/libssh/libssh_server.config" \
    #

%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_sysconfdir/libssh
install -m644 %SOURCE3 %buildroot%_sysconfdir/libssh/libssh_client.config
install -m644 %SOURCE4 %buildroot%_sysconfdir/libssh/libssh_server.config

%if "%sover" == "4"
%files -n libssh
%else
%files -n %libssh
%endif
%_libdir/libssh.so.%sover
%_libdir/libssh.so.*
%dir %_sysconfdir/libssh
%config(noreplace) %_sysconfdir/libssh/libssh_client.config
%config(noreplace) %_sysconfdir/libssh/libssh_server.config

%files devel
%_pkgconfigdir/%name.pc
%_libdir/cmake/libssh*
%_includedir/%name
%_libdir/*.so

%changelog
