Name: libtunepimp
Version: 0.5.3
Release: alt5.1.1

Group: System/Libraries
Summary: Library that provides access to the MusicBrainz server
License: LGPL

Packager: Motsyo Gennadi <drool@altlinux.ru>

Url: http://www.musicbrainz.org/

Source: ftp://ftp.musicbrainz.org/pub/musicbrainz/%name-%version.tar.gz
Patch0: libtunepimp-0.5.3-alt-system-ltdl.patch
Patch1: libtunepimp-0.5.3-alt-gcc43.patch
Patch2: %name-0.5.3-gcc44.patch
Patch3: %name-0.5.3-curl.patch

# Automatically added by buildreq on Mon Mar 26 2007
BuildPreReq: rpm-build-python zlib-devel
BuildRequires: gcc-c++ libcurl-devel libexpat-devel libflac-devel libltdl7-devel
BuildRequires: libmad-devel libmpcdec-devel libmpeg4ip-devel libmusicbrainz-devel
BuildRequires: libofa-devel libtag-devel libvorbis-devel

# for python module
BuildRequires: python-devel >= 2.4 python python-module-setuptools

%description
MusicBrainz is the second generation incarnation of the CD Index. This
server is designed to enable Audio CD and MP3/Vorbis players to download
metadata about the music they are playing.

The TunePimp library (also referred to as libtunepimp) is a development
library geared towards developers who wish to create MusicBrainz enabled
tagging applications.

%package devel
Summary: Include Files and Libraries mandatory for Development
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains all necessary include files and libraries needed
to develop applications that require TunePimp library.

%package -n python-module-tunepimp
Summary: Python module for libtunepimp
Group: Development/Python
BuildArch: noarch
Requires: %name >= %version

%description -n python-module-tunepimp
Python module for libtunepimp

%prep
%setup

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%autoreconf
%configure \
	--disable-static

%make_build

%install
%makeinstall_std

pushd python
%python_build_install --optimize=2 --record=INSTALLED_FILES
popd

%files
%doc AUTHORS ChangeLog README.*
%_bindir/puid
%_libdir/*.so.*
%_libdir/tunepimp

%files devel
%_includedir/tunepimp-0.5
%_libdir/*.so

%files -n python-module-tunepimp
%_target_libdir_noarch/python%_python_version/site-packages/*

%changelog
