%define	systemdsystemunitdir	/lib/systemd/system
%define	firmwaredir		/lib/firmware

Name: libudev0
Version: 181
Release: alt8

Summary: Shared library to access udev device information
License: LGPLv2.1+
Group: System/Legacy libraries

Url: http://kernel.org/pub/linux/utils/kernel/hotplug/
Source: %name-%version.tar
Patch: %name-%version-alt.patch

Provides: libudev = %version-%release
Obsoletes: libudev < %version-%release

BuildRequires: glib2-devel gobject-introspection-devel gperf gtk-doc pciids usbids
BuildRequires: libacl-devel libusb-compat-devel usbutils libselinux-devel
BuildRequires: kmod-devel >= 5 libblkid-devel >= 2.20

%description
This package provides shared library to access udev device information

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--enable-floppy \
	--enable-edd \
	--enable-udev_acl \
	--enable-rule_generator \
	--enable-introspection \
	%{subst_with selinux} \
%if_with bootstrap
	--disable-gtk-doc \
%endif
	--disable-gudev \
	--disable-introspection \
	--sbindir=/sbin \
	--bindir=/sbin \
	--libexecdir=/lib \
	--with-rootlibdir=/%_lib \
	--with-firmware-path=%firmwaredir/updates:%firmwaredir \
	--with-systemdsystemunitdir=%systemdsystemunitdir \
	--with-usb-ids-path=/usr/share/misc/usb.ids \
	--disable-silent-rules
%make_build

%install
%makeinstall_std

%files
/%_lib/libudev.so.*

%changelog
