# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: liburing
Version: 2.2
Release: alt1

Summary: The io_uring library
License: (GPL-2.0-only AND LGPL-2.1-or-later) OR MIT
Group: System/Libraries

Url: http://git.kernel.dk/cgit/liburing
# Author's Vcs and CI: https://github.com/axboe/liburing
Source: %name-%version.tar
BuildRequires: gcc-c++
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}

%description
Provides native async IO for the Linux 5.1+ kernel, in a fast
and efficient manner, for both buffered and O_DIRECT.

liburing provides helpers to setup and teardown io_uring instances,
and also a simplified interface for applications that don't need
(or want) to deal with the full kernel side implementation.

%package devel
Summary: Development files for Linux-native io_uring I/O access library
Group: Development/C

%description devel
This package provides header files to include and libraries to link with
for the Linux-native io_uring.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS) -ffat-lto-objects -fanalyzer
./configure \
	--prefix=%_prefix \
	--includedir=%_includedir \
	--libdir=%_libdir \
	--libdevdir=%_libdir \
	--mandir=%_mandir \
	#
%make_build --no-print-directory CFLAGS="%optflags" V=1

%install
%makeinstall_std V=1
rm %buildroot%_libdir/liburing.a

%check
# List of available probes
test/probe.t
strace -ve io_uring_register test/probe.t 2>&1 >/dev/null | grep -Po '{op.*?}' | sort -u | column -t

# Almost all tests fail on ppc64le, so there is no point to even try.
%ifnarch ppc64le %e2k
TEST_EXCLUDE="
	500f9fbadef8.t
	accept.t
	cq-overflow.t
	eeed8b54e0df.t
	fc2a85cb02ef.t
	file-verify.t
	fpos.t
	io-cancel.t
	iopoll.t
	io_uring_register.t
	link-timeout.t
	personality.t
	read-before-exit.t
	read-write.t
	recv-msgall-stream.t
	ringbuf-read.t
	rsrc_tags.t
	sendmsg_fs_cve.t
	socket.t
	sq-poll-dup.t
	sq-poll-share.t
	xattr.t
" make runtests
%endif

%files
%_libdir/liburing.so.*
%doc COPYING

%files devel
%doc README LICENSE COPYING.GPL SECURITY.md CHANGELOG examples/*.c
%_includedir/*
%_libdir/%name.so
%_pkgconfigdir/%name.pc
%_man2dir/*
%_man3dir/*
%_man7dir/*

%changelog
