%define soname 7
%ifarch %ix86
%define platform x86-linux-gcc
%else
%ifarch arm
%define platform armv5te-linux-gcc
%else
%ifarch armh
%define platform armv7-linux-gcc
%else
%ifarch %e2k
%define platform generic-gnu
%else
%ifarch aarch64
%define platform arm64-linux-gcc
%else
%define platform %_arch-linux-gcc
%endif
%endif
%endif
%endif
%endif

Name: libvpx
Version: 1.12.0
Release: alt1
Summary: VP8 video codec
Group: Video
License: BSD
Url: https://www.webmproject.org/

Source0: %name-%version.tar
Patch: %name-%version-%release.patch
# Security fixes from Ubuntu
Patch1: CVE-2023-44488.patch
Patch2: CVE-2023-5217-1.patch
Patch3: CVE-2023-5217-2.patch
Patch4: CVE-2024-5197-pre1.patch
Patch5: CVE-2024-5197-1.patch
Patch6: CVE-2024-5197-2.patch
Patch7: CVE-2024-5197-3.patch

BuildRequires: doxygen gcc-c++
%ifarch %ix86 x86_64
BuildRequires: yasm
%endif

%description
VP8 is an open video codec, originally developed by On2 and released
as open source by Google Inc. It is the successor of the VP3 codec,
on which the Theora codec was based


%package -n libvpx%soname
Summary: VP8 video codec
Group: Video
Obsoletes: libvpx6 >= 1.11.0
Conflicts: libvpx6 >= 1.11.0

%description -n libvpx%soname
VP8 is an open video codec, originally developed by On2 and released
as open source by Google Inc. It is the successor of the VP3 codec,
on which the Theora codec was based.

%package -n libvpx-devel
Summary: VP8 Libraries and Header Files
Group: Development/C
Requires: libvpx%soname = %EVR

%description -n libvpx-devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name

%package -n libvpx-utils
Summary: VP8 utilities and tools
Group: Video
Requires: libvpx%soname = %EVR

%description -n libvpx-utils
A selection of utilities and tools for VP8, including a sample encoder
and decoder.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%ifarch armh
sed -i -e 's,softfp,hard,' build/make/configure.sh
%endif

%build
%ifarch %ix86 x86_64 %arm
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%endif
./configure \
	--prefix=%prefix \
	--libdir=%_libdir \
	--enable-pic \
	--target=%platform \
	--enable-shared \
	%ifnarch x86_64
	--disable-avx \
	--disable-avx2 \
	%endif
	--disable-install-srcs \
	--enable-vp9-decoder \
	--enable-vp9-encoder \
	--enable-experimental \
	--enable-vp9-highbitdepth \
	--disable-static
%make_build

%install
%makeinstall_std

%files -n libvpx%soname
%doc AUTHORS LICENSE PATENTS CHANGELOG
%_libdir/*.so.%soname
%_libdir/*.so.%soname.*

%files -n libvpx-devel
%_includedir/vpx
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n libvpx-utils
%_bindir/*

%changelog
