%define oname wt

Name: libwt
Version: 4.5.0
Release: alt2

Summary: Wt (pronounced as witty) is a C++ library for developing web applications.

License: GPL
Group: Development/C++
Url: https://www.webtoolkit.eu

# Source-url: https://github.com/emweb/wt/archive/%version.tar.gz
Source: %name-%version.tar

BuildRequires: rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: libsqlite3-devel libmariadb-devel libunixODBC-devel
BuildRequires: libssl-devel zlib-devel libpcre-devel
BuildRequires: boost-asio-devel boost-filesystem-devel boost-interprocess-devel boost-program_options-devel
BuildRequires: libharu-devel libpango-devel libpng-devel

%description
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package devel
Summary: Wt (pronounced as witty) is a C++ library for developing web applications.
Group: System/Libraries

%description devel
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package dbo
Summary: Wt (pronounced as witty) is a C++ library for developing web applications.
Group: System/Libraries

%description dbo
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package dbo-mysql
Summary: Wt (pronounced as witty) is a C++ library for developing web applications (dbo mysql).
Group: System/Libraries

%description dbo-mysql
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package dbo-sqlite
Summary: Wt (pronounced as witty) is a C++ library for developing web applications (dbo sqlite)
Group: System/Libraries

%description dbo-sqlite
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package dbo-mssql
Summary: Wt (pronounced as witty) is a C++ library for developing web applications (dbo mssql)
Group: System/Libraries

%description dbo-mssql
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.

%package http
Summary: Wt (pronounced as witty) is a C++ library for developing web applications (http).
Group: System/Libraries

%description http
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.


%package docs
Summary: Documentation for Wt (pronounced as witty) is a C++ library for developing web applications.
Group: Development/Documentation
BuildArch: noarch

%description docs
Wt (pronounced as witty) is a C++ library for developing web applications.

The API is widget-centric and uses well-tested patterns of desktop GUI development 
tailored to the web. 
To the developer, it offers abstraction of many web-specific implementation details, 
including client-server protocols (HTTP, Ajax, WebSockets), 
and frees the developer from tedious JavaScript manipulations of HTML and dealing 
with cross-browser issues. Instead, with Wt, 
you can focus on actual functionality with a rich set of feature-complete widgets.


%prep
%setup

%build
%cmake_insource \
	-DPCRE_INCLUDE_DIR:STRING="%optflags" \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DPOCO_UNBUNDLED:BOOL=ON \
	-DWT_CPP_11_MODE=-std=c++0x

%make_build VERBOSE=1

%install
%makeinstall_std


%files
%doc Changelog LICENSE README*
%exclude %_libdir/lib*dbo*.so.*
%exclude %_libdir/lib*test*.so.*
%exclude %_libdir/lib*http*.so.*
%_libdir/lib*.so.*
%_datadir/Wt/

%files dbo
%_libdir/libwtdbo.so.*

%files dbo-mysql
%_libdir/libwtdbomysql.so.*

%files dbo-sqlite
%_libdir/libwtdbosqlite*.so.*

%files dbo-mssql
%_libdir/libwtdbomssqlserver*.so.*

%files http
%_libdir/lib*http*.so.*

%files devel
%dir %_includedir/Wt/
%_includedir/Wt/*
%_libdir/lib*.so
%exclude %_libdir/lib*test*.so
%dir %_sysconfdir/wt/
%_libdir/cmake/wt/
%config(noreplace) %_sysconfdir/wt/wt_config.xml

#files docs

%changelog
