%def_enable introspection
%def_enable vala

Name: libxfce4util
Version: 4.18.2
Release: alt2.ge76cbf7

Summary: Utility library for the Xfce desktop environment
Summary(ru_RU.UTF-8): Библиотека утилит для рабочего стола Xfce
License: LGPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/libxfce4util/start

Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/libxfce4util.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
# Automatically added by buildreq on Wed Jan 13 2010
BuildRequires: glib2-devel gtk-doc intltool
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_vala:BuildRequires: vala-tools}

%define _unpackaged_files_terminate_build 1

%description
Libxfce4util is used to share commonly used non-GTK utilities among the
Xfce applications.

%description -l ru_RU.UTF-8
Основные (не графические) утилиты Xfce.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for the %name library.

%if_enabled introspection
%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for %name.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for %name.
%endif

%if_enabled vala
%package vala
Summary: Vala bindings for %name
Group: System/Libraries
Requires: %name-devel = %EVR
BuildArch: noarch

%description vala
Vala bindings for %name.
%endif

%prep
%setup
%patch -p1
%xfce4_cleanup_version

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	%{subst_enable introspection} \
	%{subst_enable vala} \
	--enable-gtk-doc \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS README.md NEWS
%_libdir/*.so.*
%_sbindir/*

%files devel
%doc %_datadir/gtk-doc/html/%name
%dir %_includedir/xfce4/
%_includedir/xfce4/libxfce4util
%_pkgconfigdir/*.pc
%_libdir/*.so

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*.typelib

%files gir-devel
%_datadir/gir-1.0/*.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/%name-*
%endif

%changelog
