%define _name libxml++
%define ver_major 3.2
%define api_ver 3.0

%def_enable docs
%def_enable check

Name: %{_name}3
Version: %ver_major.3
Release: alt1

Summary: C++ wrapper for the libxml2 XML parser library
Group: System/Libraries
License: LGPL-2.1
Url: https://libxmlplusplus.sourceforge.net/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires(pre): meson
BuildRequires: mm-common gcc-c++ 
BuildRequires: libglibmm-devel >= 2.32.0
BuildRequires: libxml2-devel >= 2.7.7
%{?_enable_docs:BuildRequires: doxygen graphviz docbook-style-xsl xsltproc}

%description
libxml++ is a C++ wrapper for the libxml2 XML parser library.
It has SAX and DOM-like APIs, but does not attempt to conform exactly to
the DOM specification. Its API is simpler than the underlying libxml2 C API.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %EVR

%description devel
This package contains the headers and libraries for libxml++ development.

%package devel-doc
Summary: Development documentation for %name
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains the development documentation for libxml++ library.

%prep
%setup -n %_name-%version

%build
%{?_enable_snapshot:mm-common-prepare --force --copy}
%meson \
    %{?_enable_snapshot:-Denable-maintainer-mode=true} \
    %{?_enable_docs:-Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_libdir/%_name-%api_ver.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%_name-%api_ver.so
%_libdir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc

%if_enabled docs
%files devel-doc
%_datadir/devhelp/books/%_name-%api_ver/*.devhelp2
%_docdir/%_name-%api_ver/*
%endif

%changelog
