%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: lightdm-kde-greeter
Version: 0.4.23
Release: alt1.p10.2
Group: Graphical desktop/Other
Summary: LightDM KDE5 Greeter
License: GPL-3.0+
Url: https://invent.kde.org/plasma/lightdm-kde-greeter.git

Source: %name-%version.tar

%define greeter_user_home_dir %_var/lib/ldm/%name

%K5init

BuildRequires(pre): rpm-build-kf5
BuildRequires(pre): rpm-build-qml
BuildRequires(pre): rpm-build-ubt
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: lightdm-devel
BuildRequires: qt5-base-devel qt5-x11extras-devel qt5-declarative-devel qt5-tools-devel qt5-tools-devel-static
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: extra-cmake-modules
BuildRequires: kf5-kdeclarative-devel kf5-kiconthemes-devel kf5-plasma-framework-devel kf5-kconfig-devel kf5-ki18n-devel kf5-kauth-devel kf5-kconfigwidgets-devel
BuildRequires: kf5-kcmutils-devel
# deps of used stuff
BuildRequires: kf5-kcoreaddons-devel kf5-kpackage-devel kf5-kservice-devel
BuildRequires: kf5-networkmanager-qt-devel

Requires: lightdm
Requires: plasma5-workspace-qml
Requires: polkit

Provides: lightdm-greeter

%qml_req_skipall 0

# libqt5-qml should provide qml(QtQml)
%qml_add_req_skip QtQml

# libqt5-quick should provide
%qml_add_req_skip QtQuick

# qt5-graphicaleffects should provide
%qml_add_req_skip QtGraphicalEffects

# libkf5quickaddons should provide
%qml_add_req_skip org.kde.kquickcontrolsaddons

# plasma5-workspace-qml should provide
%qml_add_req_skip org.kde.plasma.wallpapers.image

# this package itself should provide
%qml_add_req_skip ConnectionEnum

%description
This package provides a KDE-based LightDM greeter engine.

This is a fork of KDE4-based LightDM greeter engine for KDE5.

%prep
%setup

%build
%K5build \
%_K5if_ver_gteq %ubt_id M110
        -DGREETER_WAYLAND_SESSIONS_FIRST=ON \
%endif
        -DGREETER_IMAGES_DIR=%greeter_user_home_dir/images

%install
%K5install
%K5install_move data kcm_lightdm kpackage

%find_lang --with-kde %name
%find_lang --with-kde --append --output=%name.lang kcm_lightdm
%find_lang --with-kde --append --output=%name.lang lightdm_kde_greeter
%find_lang --with-kde --append --output=%name.lang lightdm_theme_userbar

# Add alternatives for xgreeters
mkdir -p %buildroot%_altdir
printf '%_datadir/xgreeters/lightdm-default-greeter.desktop\t%_datadir/xgreeters/lightdm-kde-greeter.desktop\t300\n' > %buildroot%_altdir/lightdm-kde-greeter

%triggerin -- lightdm-kde-greeter < 0.4.23-alt1.p10.2
# previous versions could create files owned by root
if [ -e "%greeter_user_home_dir" ]; then
    # and this is in case there are any symlinks
    find %greeter_user_home_dir ! -type f,d -delete
    chown --recursive _ldm:_ldm %greeter_user_home_dir
fi

%files -f %name.lang
%config(noreplace) %_sysconfdir/lightdm/lightdm-kde-greeter.conf
%_altdir/lightdm-kde-greeter
%_sbindir/lightdm-kde-greeter
%_datadir/xgreeters/lightdm-kde-greeter.desktop
%_datadir/dbus-1/system.d/org.kde.kcontrol.kcmlightdm.conf
%_K5libexecdir/kauth/kcmlightdmhelper
%_K5libexecdir/lightdm-kde-greeter-rootimage
%_K5libexecdir/lightdm-kde-greeter-wifikeeper
%_K5dbus_sys_srv/org.kde.kcontrol.kcmlightdm.service
%_libexecdir/systemd/user/lightdm-kde-greeter-wifikeeper.service
%_datadir/lightdm-kde-greeter/
%_K5xdgapp/kcm_lightdm.desktop
%_K5plug/plasma/kcms/systemsettings/kcm_lightdm.so
%_K5data/kpackage/kcms/kcm_lightdm/
%_datadir/polkit-1/actions/org.kde.kcontrol.kcmlightdm.policy


%changelog
