%def_with mysql
%def_with ldap
%def_with gssapi
%def_with ssl
%def_with lua
%def_without gamin
%def_with pgsql
%def_with tests
%def_with maxminddb
%def_with libdeflate

%define lighttpd_user lighttpd
%define lighttpd_group lighttpd
%define lighttpd_spool %_spooldir/%name

%define docdir %_docdir/%name-%version-doc

Name: lighttpd
Version: 1.4.82
Release: alt1

Summary: A fast webserver with minimal memory-footprint
License: BSD
Group: System/Servers

# git clone https://git.lighttpd.net/lighttpd/lighttpd1.4.git
Url: http://www.lighttpd.net

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

Requires(pre): shadow-utils shadow-groups webserver-common
Provides: webserver

BuildRequires(pre): rpm-macros-webserver-common
# Automatically added by buildreq on Wed Dec 02 2020
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libcom_err-devel libcrypt-devel libkrb5-devel libsasl2-3 perl pkg-config python2-base sh4
BuildRequires: bzlib-devel libbrotli-devel libfcgi-devel libpcre2-devel libxxhash-devel zlib-devel

%{?_with_maxminddb:BuildPreReq: libmaxminddb-devel}
%{?_with_mysql:BuildPreReq: libmysqlclient-devel}
%{?_with_gssapi:BuildPreReq: libkrb5-devel}
%{?_with_ssl:BuildPreReq: libssl-devel}
%{?_with_ldap:BuildPreReq: libldap-devel}
%{?_with_lua:BuildPreReq: lua-devel}
%{?_with_gamin:BuildPreReq: libgamin-devel}
%{?_with_pgsql:BuildPreReq: libpq-devel}
%{?_with_libdeflate:BuildPreReq: libdeflate-devel}
%{?_with_tests:BuildPreReq: perl-devel perl-Digest-SHA}

%description
%name is intented to be a frontend for ad-servers which have to deliver
small files concurrently to many connections.

%if_with mysql
%package mysql-vhost
Summary: MySQL based vhosting %name module
Group: System/Servers
Requires: %name = %version-%release

%description mysql-vhost
This module provides virtual hosts (vhosts) based on a MySQL table.
%endif #mysql

%if_with ldap
%package auth-ldap
Summary: LDAP authentication for %name
Group: System/Servers
Requires: %name = %version-%release

%description auth-ldap
LDAP authentication for %name

%package ldap-vhost
Summary: LDAP based vhosting %name module
Group: System/Servers
Requires: %name = %version-%release

%description ldap-vhost
This module provides virtual hosts (vhosts) based on a LDAP.
%endif #ldap

%if_with maxminddb
%package maxminddb
Summary: MaxMind GeoIP2 module (plugin) for %name.
Group: System/Servers
Requires: %name = %version-%release

%description maxminddb
The module loads a geoip database of type "country" or "city" and sets new
ENV vars based on ip record lookups.
%endif #maxminddb

%if_with gssapi
%package auth-gssapi
Summary: GSSAPI authentication for %name
Group: System/Servers
Requires: %name = %version-%release

%description auth-gssapi
GSSAPI authentication for %name
%endif #gssapi

%if_with pgsql
%package pgsql-vhost
Summary: PostgreSQL based vhosting %name module
Group: System/Servers
Requires: %name = %version-%release

%description pgsql-vhost
This module provides virtual hosts (vhosts) based on a PostgreSQL table.
%endif #pgsql

%package rrdtool
Summary: rrdtool support %name module
Group: System/Servers
Requires: %name = %version-%release, rrdtool

%description rrdtool
mod_rrdtool is used to monitor the traffic and load on the webserver.

%package doc
Summary: %name documentation
Group: Documentation
BuildArch: noarch

%description doc
Documentation for %name.

%prep
%setup
%patch0 -p1

libtoolize -f -c
%autoreconf

%build
%configure --libdir=%_libdir/%name \
                          --with-brotli \
                          --with-zlib \
                          --with-bzip2 \
                          --with-uuid \
                          --with-xxhash \
    %{?_with_mysql:       --with-mysql} \
    %{?_with_pgsql:       --with-pgsql} \
    %{?_with_ssl:         --with-openssl} \
    %{?_with_ldap:	  --with-ldap} \
    %{?_with_lua:	  --with-lua} \
    %{?_with_gamin:	  --with-fam} \
    %{?_with_gssapi:	  --with-krb5} \
    %{?_with_maxminddb:	  --with-maxminddb} \
    %{?_with_libdeflate:  --with-libdeflate} \
    %{?_with_lua:	  LUA_CFLAGS="-I/usr/include/" LUA_LIBS="-llua"}

%make_build

# run tests for sanity checks
#pushd tests
#./wrapper.sh . .. ./prepare.sh
#./wrapper.sh . .. ./run-tests.pl
#popd

%install
%makeinstall libdir=%buildroot%_libdir/%name

mkdir -p %buildroot%_sysconfdir/{rc.d/init.d,sysconfig}
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot{%_spooldir/%name/tmp,%_var/log/%name,%_var/lib/%name}

# inirscript, sysconfig and unit
install -m755 %name.init %buildroot%_initdir/%name
#install -m644 doc/initscripts/sysconfig.lighttpd %buildroot%_sysconfdir/sysconfig/lighttpd
install -m644 doc/systemd/lighttpd.service %buildroot%_unitdir/lighttpd.service
install -m644 doc/systemd/lighttpd-http-ipv4.socket %buildroot%_unitdir/lighttpd-http-ipv4.socket
install -m644 doc/systemd/lighttpd-http-ipv6.socket %buildroot%_unitdir/lighttpd-http-ipv6.socket
install -m644 doc/systemd/lighttpd-https-ipv4.socket %buildroot%_unitdir/lighttpd-https-ipv4.socket
install -m644 doc/systemd/lighttpd-https-ipv6.socket %buildroot%_unitdir/lighttpd-https-ipv6.socket

# configs
cp -rp doc/config %buildroot%_sysconfdir/%name
find %buildroot%_sysconfdir/%name -type f -name "Makefile*" -delete

# logrotate script
install -pDm644 lighttpd.logrotate %buildroot%_sysconfdir/logrotate.d/%name

# docs
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir/outdated
cp -a doc/outdated/*.txt %buildroot%docdir/outdated/

%if_with tests
%check
%make -C tests leak-check
%endif #tests

%pre
%_sbindir/groupadd -r -f %lighttpd_group ||:
%_sbindir/useradd -r -g %lighttpd_group -d /dev/null -s /dev/null -N %lighttpd_user \
	2> /dev/null > /dev/null ||:
gpasswd -a %lighttpd_user %webserver_group

%post
%post_service lighttpd

%preun
%preun_service lighttpd

%files
%doc README INSTALL COPYING AUTHORS
%config %_initdir/%name
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_unitdir/*
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name/conf.d
%dir %attr(0750,root,%lighttpd_group) %_sysconfdir/%name/vhosts.d
%config(noreplace) %attr(0644,root,%lighttpd_group) %_sysconfdir/%name/*.conf
%config(noreplace) %attr(0644,root,%lighttpd_group) %_sysconfdir/%name/*/*.conf
%_sysconfdir/%name/*/mod.template
%_sysconfdir/%name/vhosts.d/*
%_man8dir/*
%dir %attr(1770,root,%lighttpd_group) %lighttpd_spool
%dir %attr(1770,root,%lighttpd_group) %lighttpd_spool/tmp
%dir %attr(1770,root,%lighttpd_group) %_var/lib/%name
%dir %attr(1770,root,%lighttpd_group) %_var/log/%name
%dir %_libdir/%name
%_libdir/%name/*.so

%if_with mysql
%exclude %_libdir/%name/*_vhostdb_mysql.so
%endif #mysql

%if_with pgsql
%exclude %_libdir/%name/*_vhostdb_pgsql.so
%endif #pgsql

%if_with ldap
%exclude %_libdir/%name/*_authn_ldap.so
%exclude %_libdir/%name/*_vhostdb_ldap.so
%endif ldap

%if_with gssapi
%exclude %_libdir/%name/*_authn_gssapi.so
%endif gssapi

%if_with maxminddb
%exclude %_libdir/%name/*_maxminddb.so
%endif #maxminddb

%exclude %_libdir/%name/*_rrdtool.so
%_sbindir/*
%exclude %_libdir/%name/*.la

%files doc
%docdir

%if_with mysql
%files mysql-vhost
%_libdir/%name/*_vhostdb_mysql.so
%endif #mysql

%if_with ldap
%files auth-ldap
%_libdir/%name/*_authn_ldap.so

%files ldap-vhost
%_libdir/%name/*_vhostdb_ldap.so
%endif #ldap

%if_with gssapi
%files auth-gssapi
%_libdir/%name/*_authn_gssapi.so
%endif #gssapi

%if_with pgsql
%files pgsql-vhost
%_libdir/%name/*_vhostdb_pgsql.so
%endif #pgsql

%if_with maxminddb
%files maxminddb
%_libdir/%name/*_maxminddb.so
%endif #maxminddb

%files rrdtool
%_libdir/%name/*rrdtool.so

%changelog
