Name: lilo
Version: 24.2
Release: alt3
Summary: The boot loader for Linux and other operating systems
License: MIT
Group: System/Kernel and hardware
Url: https://www.joonet.de/%name
Source0: %url/ftp/sources/%name-%version.tar
#Vcs-Git: https://salsa.debian.org/joowie-guest/upstream_lilo.git
Source1: keytab-lilo.c
Patch1: lilo-23.2-owl-makefile.patch
Patch2: lilo-23.2-alt-owl-fixes.patch
Patch3: lilo-24.2-alt-Makefile.patch
Patch11: lilo-23.0-mdk-part.patch
Patch12: lilo-24.2-alt-constants.patch
Patch13: lilo-23.1-alt-defaults.patch
Patch14: lilo-23.0-alt-lba32_linear.patch
Patch15: lilo-24.0-alt-mkrescue.patch
Patch17: lilo-24.2-alt-blkid.patch
Patch18: lilo-23.0-alt-raid_index.patch
Patch19: lilo-22.8-alt-devmapper.patch
Patch20: lilo-22.8-alt-md-devmapper.patch
Patch21: lilo-24.2-suse-gfx.patch
Patch22: lilo-24.0-alt-format.patch
Patch23: lilo-24.2-alt-gcc-10-fno-common.patch
ExclusiveArch: %ix86 x86_64

BuildRequires: dev86 libblkid-devel libdevmapper-devel perl(Pod/Text.pm) %_bindir/uudecode

%description
LILO (LInux LOader) is a basic system program which boots your Linux
system.  LILO loads the Linux kernel from a floppy or a hard drive, boots
the kernel and passes control of the system to the kernel.  LILO can also
boot other operating systems.


%package doc
Summary: More documentation for %name
Group: System/Kernel and hardware
BuildArch: noarch

%description doc
LILO (LInux LOader) is a basic system program which boots your Linux
system.  LILO loads the Linux kernel from a floppy or a hard drive, boots
the kernel and passes control of the system to the kernel.  LILO can also
boot other operating systems.

This package contains extra documentation for LILO.


%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch17 -p1
%patch18 -p1
#patch19 -p1
#patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1

sed -i 's/\(mkdir \)/\1-p /g' Makefile
sed -i 's/\(keytab-lilo\)\.pl/\1/g' Makefile doc/user.tex
sed -i '/^[[:blank:]]*@echo/d' images/Makefile


%build
%make_build CC=%__cc OPT="%optflags -Wno-strict-aliasing" all
%__cc %optflags -o keytab-lilo %SOURCE1
gzip -9c CHANGELOG > CHANGELOG.gz


%install
%make_install DESTDIR=%buildroot install

%define docdir %_docdir/%name-%version
install -d -m 0755 %buildroot%docdir/{html,images}
install -p -m 0644 NEWS README* CHANGELOG.* COPYING QuickInst TODO %buildroot%docdir/
install -p -m 0644 doc/html/* %buildroot%docdir/html/
install -p -m 0644 images/{README,*.{bmp,dat}} %buildroot%docdir/images/


%post
if [ -f /etc/%name.conf -a -x %_sbindir/detectloader.sh -a -x %_sbindir/detectliloboot.sh -a -f /proc/partitions ]; then
	if %_sbindir/detectloader.sh $(%_sbindir/detectliloboot.sh) | grep -q '^lilo$'; then
		/sbin/%name || echo "Please run %name manually." >&2
	fi
fi


%files
/boot/*
%exclude /boot/*
%exclude %_sysconfdir/*
/sbin/*
%_sbindir/*
%_man5dir/*
%_man8dir/*
%dir %docdir
%docdir/COPYING


%files doc
%dir %docdir
%docdir/*
%exclude %docdir/COPYING


%changelog
