# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# rt-tests is taken by perl tests for RT
Name:     linux-rt-tests
Version:  2.1
Release:  alt1

Summary:  Programs that test various rt-linux features
License:  GPL-2.0-or-later
Group:    System/Kernel and hardware
Url:      https://wiki.linuxfoundation.org/realtime/documentation/howto/tools/rt-tests
Vcs:      git://git.kernel.org/pub/scm/utils/rt-tests/rt-tests.git

Source: %name-%version.tar
BuildRequires(pre): rpm-build-python3
BuildRequires: libnuma-devel

%description
rt-tests is a test suite, that contains programs (such as cyclictest,
hwlatdetect, hackbench) to test various Real Time Linux features.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%make_build CFLAGS="%optflags" prefix=/usr

%install
%makeinstall_std prefix=/usr

%files
%doc COPYING MAINTAINERS README.markdown src/hwlatdetect/hwlat.txt
%_bindir/*
%python3_sitelibdir_noarch/*.py
%_man8dir/*.8*

%changelog
