%def_disable check
%define xdg_name in.lsp_plug.lsp_plugins

Name: lsp-plugins
Version: 1.1.30
Release: alt2

Summary: Linux Studio Plugins
Group: Sound
License: LGPL-3.0
Url: https://lsp-plug.in/

#Source: https://sourceforge.net/projects/%name/files/%name/%version/%name-src-%version.tar.gz
Vcs: https://github.com/sadko4u/lsp-plugins
Source: https://github.com/sadko4u/%name/archive/%version/%name-%version.tar.gz

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++
BuildRequires: lv2-devel libjack-devel ladspa_sdk
BuildRequires: libsndfile-devel libcairo-devel
BuildRequires: libGL-devel
BuildRequires: %_bindir/php

ExclusiveArch: %ix86 x86_64 aarch64 %e2k

%description
LSP (Linux Studio Plugins) is a collection of open-source plugins
currently compatible with LADSPA, LV2 and LinuxVST formats.

%package -n jack-%name
Summary: LSP (Linux Studio Plugins) JACK plugins
Group: Sound

%description -n jack-%name
LSP (Linux Studio Plugins) JACK plugins.

%package -n ladspa-%name
Summary: LSP (Linux Studio Plugins) LADSPA plugins
Group: Sound

%description -n ladspa-%name
LSP (Linux Studio Plugins) LADSPA plugins.

%package -n lv2-%name
Summary: LSP (Linux Studio Plugins) LV2 plugins
Group: Sound

%description -n lv2-%name
LSP (Linux Studio Plugins) LV2 plugins.

%package -n vst-%name
Summary: LSP (Linux Studio Plugins) LinuxVST plugins
Group: Sound

%description -n vst-%name
LSP (Linux Studio Plugins) LinuxVST plugins.

%package doc
Summary: Documentation for LSP (Linux Studio Plugins) plugins
Group: Sound
BuildArch: noarch

%description doc
Documentation for LSP (Linux Studio Plugins) plugins.

%prep
%setup -n %name-%version
%ifarch %e2k
sed -i "s|VSTCALLBACK __cdecl|VSTCALLBACK|" include/3rdparty/steinberg/vst2.h
%endif

%build
export PLATFORM=Linux SYSTEM=Linux
export VERSION=%version
%make PREFIX=%_prefix \
    BUILD_PROFILE=%_arch \
    CC_FLAGS="-DLSP_NO_EXPERIMENTAL %optflags_warnings %(getconf LFS_CFLAGS)" \
    BIN_PATH=%_bindir LIB_PATH=%_libdir \
    DOC_PATH=%_docdir VERBOSE=1

%install
%makeinstall_std PREFIX=%_prefix LIB_PATH=%_libdir all install_xdg

%check
%make check

%files -n jack-%name
%_bindir/*
%dir %_libdir/%name
%_libdir/%name/%name-jack-core-%version.so
%_libdir/%name/%name-r3d-glx.so
%_desktopdir/%{xdg_name}_*.desktop
%_datadir/desktop-directories/%name.directory
%_xdgmenusdir/applications-merged/%name.menu
%_iconsdir/hicolor/*/apps/%name.*

%doc CHANGELOG.txt README.txt

%files -n ladspa-%name
%_libdir/ladspa/*
%doc CHANGELOG.txt README.txt

%files -n lv2-%name
%_libdir/lv2/*
%doc CHANGELOG.txt README.txt

%files -n vst-%name
%_libdir/vst/*
%doc CHANGELOG.txt README.txt

%files doc
%_defaultdocdir/%name/


%changelog
