%define target_lua_version 5.1

# Original package name LuaSocket
%define oname luasocket
%define oversion 3.0rc1-2
%define rockspec luasocket-3.0rc1-2.rockspec
Name: lua%target_lua_version-module-%oname
Version: 3.0rc1
Release: alt4_lr2
Summary: Network support for the Lua language
License: MIT
Group: Development/Other
Url: http://luaforge.net/projects/luasocket/
Provides: luarocks%target_lua_version(%oname) = %EVR

%if "%target_lua_version" == "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %EVR
Provides: lua5-%oname = %version
%endif

Source: https://github.com/diegonehab/luasocket/archive/v3.0-rc1.zip
Source1: https://luarocks.org/manifests/luarocks/luasocket-3.0rc1-2.rockspec

BuildPreReq: rpm-macros-lua >= 1.4
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks

%description
      LuaSocket is a Lua extension library that is composed by two parts: a C core
      that provides support for the TCP and UDP transport layers, and a set of Lua
      modules that add support for functionality commonly needed by applications
      that deal with the Internet.

%prep
%setup -n %oname-3.0-rc1

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc
# FIXME: when ALT rpm will support dir->symlink upgrade (#34619)
#%%luarocks_move_docs etc
#%%luarocks_move_docs samples
#%%luarocks_move_docs test
	subst 's|bin/lua$|bin/lua%current_lua_version|' %buildroot%luarocks_dbdir/%oname/%oversion/test/udp-zero-length-send*

%check
%lua_path_add_buildroot
( %lua %buildroot%luarocks_dbdir/%oname/%oversion/test/testsrvr.lua ||: )&
sleep 1
%lua %buildroot%luarocks_dbdir/%oname/%oversion/test/testclnt.lua

%files
%lua_modulesdir/*
%lua_modulesdir_noarch/*
%luarocks_dbdir/%oname
%doc FIX LICENSE* NEW TODO WISH docs_from_rockstree/*
%exclude %luarocks_dbdir/manifest

%changelog
