%define target_lua_version 5.3

# Original package name LuaSec
%define oname luasec
%define oversion 0.8-1
%define rockspec luasec-0.8-1.rockspec
Name: lua%target_lua_version-module-%oname
Version: 0.8
Release: alt1_lr1
Summary: A binding for OpenSSL library to provide TLS/SSL communication over LuaSocket.
License: MIT
Group: Development/Other
Url: https://github.com/brunoos/luasec/wiki
Provides: luarocks%target_lua_version(%oname) = %EVR

%if "%target_lua_version" == "5.3"
Obsoletes: lua-module-%oname < %EVR
Provides: lua-module-%oname = %version
%endif

Source: https://github.com/brunoos/luasec/archive/luasec-0.8.tar.gz
Source1: https://luarocks.org/manifests/luarocks/luasec-0.8-1.rockspec

Requires: luarocks%target_lua_version(luasocket) 

BuildPreReq: rpm-macros-lua >= 1.4
BuildRequires: luarocks%target_lua_version(luasocket) 
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks libssl-devel

%description
This version delegates to LuaSocket the TCP connection establishment between the client and server. Then LuaSec uses this connection to start a secure TLS/SSL session.

%prep
%setup -n %oname-%oname-%version
#FIXME untie from embedded luasocket
# rm -r src/luasocket

%install
%luarocks_make %SOURCE1
%luarocks_move_docs samples

%files
%lua_modulesdir/*
%lua_modulesdir_noarch/*
%luarocks_dbdir/%oname
%doc CHANGELOG LICENSE* README* docs_from_rockstree/*
%exclude %luarocks_dbdir/manifest

%changelog
