%define ver	2.8.9
%define subver  pre.1
%define bver	2-8-9

Name: lynx
Version: %ver
Release: alt1.%subver.1

Summary: Text based browser for the world wide web
License: GPLv2
Url: http://lynx.browser.org
Group: Networking/WWW

Source: lynx.tar
Source1: %name.wmconfig
Source100: lynx-16.xpm
Source101: lynx-32.xpm
Source102: lynx-48.xpm

Requires: %name-data = %version-%release

Patch: %name-pld.patch
Patch1: lynx2-8-9-alt-cfg.patch
Patch2: %name-tmpdir.patch
Patch3: lynx2-8-4-fix-ugly-color.patch
Patch4: %name-284-ipv6-salen.patch
Patch5: lynx2-8-5-alt-i18n.patch
Patch6: %name.mouse-enable.patch
Patch7: %name.printers.patch

Provides: webclient, lynx-ssl = %version
Obsoletes: lynx-ssl

# Automatically added by buildreq on Wed Apr 03 2002
BuildRequires: lclint libncursesw-devel libssl ncompress openssl-devel postfix sharutils telnet unzip zip zlib-devel

%description
This a terminal based WWW browser. While it does not make any attempt
at displaying graphics, it has good support for HTML text formatting,
forms, and tables.

%package data
Summary: data files for lynx
Group: Networking/WWW
BuildArch: noarch

%description data
Data files for lynx

%prep
%setup  -q -c
%patch0 -p1
%patch1 -p1
%patch2 -p0
%patch3 -p1
#patch4 -p1
#patch5 -p1
%patch6 -p1
%patch7 -p0

%build
#sed -i "s|\\$\\(SSL_DIR\\)/include|%_includedir/openssl|" makefile.in
#don't use configure macros
#	--libdir=/etc \
CFLAGS="$RPM_OPT_FLAGS -w -DUSE_SSL -D_USE_PLD -U_GNU_SOURCE " LDFLAGS=-s \
%_configure_update_config
./configure \
	--prefix=/usr \
	--sysconfdir=/etc \
	--disable-font-switch           \
	--enable-addrlist-page          \
	--enable-charset-choice         \
	--enable-cgi-links              \
	--enable-color-style            \
	--enable-default-colors         \
	--enable-externs                \
	--enable-file-upload            \
	--enable-internal-links         \
	--enable-ipv6                   \
	--enable-japanese-utf8          \
	--enable-justify-elts           \
	--enable-locale-charset         \
	--enable-libjs                  \
	--enable-nested-tables          \
	--enable-nls                    \
	--enable-nsl-fork               \
	--enable-persistent-cookies     \
	--enable-prettysrc              \
	--enable-read-eta               \
	--enable-scrollbar              \
	--enable-source-cache           \
	--enable-warnings               \
	--with-ssl \
	--with-zlib $SOCKS5 \
	--with-screen=ncursesw

# removed --enable-exec-links --enable-exec-scripts,
# it goes together with LOCAL_EXECUTION_LINKS_* in lynx.cfg

# (cf INSTALLATION file for more about the options)
# --with-included-gettext  is the default
# --enable-kbd-layout not useful enough
# --enable-cjk not needed for CJK and may go away in a future release

#make_build
# non SMP compatible build
make

%install
install -d %buildroot%_sysconfdir/X11/wmconfig
install -d %buildroot%_datadir/lynx/{lynx_help/keystrokes,test}

%makeinstall libdir=%buildroot/etc mandir=%buildroot%_man1dir

for i in `find lynx_help test -type f `; do
	install $i %buildroot%_datadir/lynx/$i
done

install %SOURCE1 %buildroot%_sysconfdir/X11/wmconfig/lynx
install -m644 samples/lynx.lss %buildroot%_sysconfdir/

bzip2 -9f docs/* README lynx.hlp||true

mkdir -p %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Lynx
Comment=Lynx - A text mode web browser
Icon=%name
Exec=%name
Terminal=true
Categories=Network;WebBrowser;
EOF

sed -i "s!PATH_TO/lynx_help/!"%_datadir"/lynx/lynx_help/!g" %buildroot%_sysconfdir/lynx.cfg

install -m 644 %SOURCE100 %buildroot/%_miconsdir/lynx.xpm
install -D -m 644 %SOURCE101 %buildroot/%_niconsdir/lynx.xpm
install -m 644 %SOURCE101 %buildroot/%_liconsdir/lynx.xpm

%find_lang %name

%files -f %name.lang
%doc docs README.bz2 lynx.hlp.bz2

%config(noreplace) %verify(not size mtime md5) %_sysconfdir/lynx.cfg
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/lynx.lss

%_bindir/*
%_mandir/man?/*
%_desktopdir/%name.desktop
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_miconsdir/%name.xpm

%files data
%_datadir/%name

%changelog
