%define _unpackaged_files_terminate_build 1

%define alt_keyring /usr/lib/alt-gpgkeys/pubring.gpg
%define macroscop_repos https://packages.macroscop.com/rpm/altlinux
%define macroscop_keyid 81867B1F80369656

%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif
%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

Name: macroscop-repo
Version: 1.0
Release: alt1

Summary: Macroscop GPG-key and repository link
License: GPL-3
Group: System/Configuration/Packaging

ExclusiveArch: x86_64

Source: %name-%version.tar
Url: https://macroscop.com/

Packager: Leonid Krivoshein <klark@altlinux.org>

Requires: apt-conf
Requires: apt-https
Requires: alt-gpgkeys

%description
This package contains just a link to the Macroscop repository
and a public GPG key.

%prep
%setup

%build
%if "%altbranch" == "p10"
echo "rpm [macroscop] %macroscop_repos p10/%_arch main" \
    > etc/apt/sources.list.d/macroscop.list
chmod 0644 etc/apt/sources.list.d/macroscop.list
%endif
sed -i \
    -e 's,@alt_keyring@,%alt_keyring,' \
    -e 's,@macroscop_keyid@,%macroscop_keyid,' \
	usr/lib/rpm/macroscop-repo.filetrigger
mkdir -p -m 0755 %buildroot
mv -f etc usr %buildroot/

%preun
if [ -s "%alt_keyring" ] &&
   gpg --list-packets "%alt_keyring" |grep -F -qs "keyid: %macroscop_keyid"
then
	echo "Removing Macroscop GPG key form public keyring..." >&2
	gpg --keyring "%alt_keyring" --no-default-keyring \
	    --batch --yes --delete-keys "%macroscop_keyid"
fi

%post
echo "%alt_keyring" |/usr/lib/rpm/macroscop-repo.filetrigger

%files
%dir /etc/ssl/macroscop
/etc/ssl/macroscop/macroscop.gpg
/etc/apt/vendors.list.d/macroscop.list
%config(noreplace) /etc/apt/sources.list.d/macroscop.list
/usr/lib/rpm/macroscop-repo.filetrigger

%changelog
