Name: man-pages
Version: 5.12
Release: alt1

Summary: Man (manual) pages from the Linux Documentation Project
Summary(ru_RU.UTF8): Руководства пользователя Linux Documentation Project
License: distributable
Group: Documentation
Url: http://www.kernel.org/doc/man-pages/

# http://www.kernel.org/pub/linux/docs/man-pages/%name-%version.tar.xz
Source: %name-%version.tar
Source1: %name-extra.tar

Requires: man >= 1.5i2-alt4
BuildArch: noarch
Obsoletes: gnumaniak

# due to major.3/minor.3 (see #19717)
Conflicts: libSDL_sound-devel <= 1.0.3-alt1

# due to resolver.5 (see #19784)
Conflicts: bind-utils <= 9.3.6-alt3

# due to security.2
Conflicts: libcint-devel <= 7.3.00-alt1.svn20090707

# due to attr.5
Conflicts: attr < 2.4.47.0.35.dce9
# due to *attr.2
Conflicts: libattr-devel < 2.4.47.0.35.dce9

# due to fd.4
Conflicts: fdutils < 5.5.20081027-alt2

# due to keyrings.7 and *-keyring.7 (see #33254)
Conflicts: keyutils < 1.5.10

%description
A large collection of man pages (reference material) from the Linux
Documentation Project (LDP).  The man pages are organized into the
following sections:
	1:  User commands (intro and pages not maintained by FSF)
	2:  System calls
	3:  Libc calls
	4:  Devices (e.g. hd, sd)
	5:  File formats and protocols (e.g. wtmp, /etc/passwd, nfs)
	6:  Games (intro only)
	7:  Conventions, macro packages, etc.
	8:  System administration (intro only)

%description -l ru_RU.UTF8
Большая коллекция справочного материала разработанного в рамках Linux
Documentation Project (LDP). Материалы сгруппированы по секциям:
	1:  Команды пользователя (введение)
	2:  Системные вызовы
	3:  Вызовы libc
	4:  Устройства (например, hd, sd)
	5:  Форматы файлов и протоколов (например, wtmp, /etc/passwd, nfs)
	6:  Игры (только введение)
	7:  Соглашения, макропакеты, и т.д.
	8:  Системное администрирование (только введение)

%package utils
Summary: The scripts for man-pages maintenance tasks
Summary(ru_RU.UTF8): The scripts for man-pages maintenance tasks.
Group: System/Internationalization

%description utils
The scripts for man-pages maintenance tasks.
They may be useful for downstream man-pages package maintainers or for
man-pages translators.

%prep
%setup -b1
sed -i '/--silent/d' Makefile

%build
rm man3/crypt{,_r}.3

%install
mkdir -p %buildroot%_datadir/%name
%makeinstall_std prefix=%_prefix
install -pm644 scripts/* %buildroot%_datadir/%name/

# strip COLOPHON section
find %buildroot%_mandir -type f -print0 |
	xargs -r0 sh scripts/remove_COLOPHON.sh

%files
%doc README* *.Announce *.lsm
%_mandir/man?/*

%files utils
%_datadir/%name/

%changelog
