%define uname   MangoHud
%define srcname %uname-v%version-Source
%define srcpath %uname-v%version

Name: mangohud
Version: 0.7.2
Release: alt0.p10.1

Summary: A Vulkan overlay layer for monitoring FPS, temperatures, CPU/GPU load and more
License: MIT
Group: Games/Arcade

Url: https://github.com/flightlessmango/%uname
Source: https://github.com/flightlessmango/%uname/releases/download/v%version/%srcname.tar.xz

Patch0: %name-python3.patch
Patch1: %name-%version-p10.1-alt-fix-compilation.patch

BuildRequires: appstream 
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: git-core
BuildRequires: glslang
BuildRequires: libGLEW-devel
BuildRequires: libXrandr-devel
BuildRequires: libdbus-devel
BuildRequires: libglfw3-devel
BuildRequires: libspdlog-devel
BuildRequires: libstdc++-devel-static
BuildRequires: libvulkan-devel
BuildRequires: libwayland-client-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libxnvctrl-devel
BuildRequires: meson
BuildRequires: nlohmann-json-devel
BuildRequires: python3-dev
BuildRequires: python3-module-mako

%description
A Vulkan overlay layer for monitoring FPS, temperatures, CPU/GPU load and more.

To enable the MangoHud Vulkan overlay layer, set `MANGOHUD=1` in the shell,
or use the `mangohud` command to launch programs.
See '%_docdir/%name' for configuration details.
%ifarch %ix86 x86_64

The `goverlay` package provides a third-party GUI frontend for MangoHud.
%endif

%package -n mangoapp
Summary: A transparent background application with a built-in %uname for gamescope
Group: Games/Arcade
Requires: %name

%description -n mangoapp
A transparent background OpenGL application with a built-in %uname designed to be run inside a gamescope instance.

%package -n mangoplot
Summary: Local visualization
Group: Games/Arcade
Requires: %name
BuildArch: noarch

%description -n mangoplot
mangoplot is a plotting script that is shipped with MangoHud: on a given folder,
it takes each log file, makes a 1D heatmap of its framerates,
then stacks the heats maps vertically to form a 2D graph for
easy visual comparison between benchmarks.

%prep
%setup -n %srcpath
%patch0 -p1
%patch1 -p2

%build
%meson \
  -Duse_system_spdlog=enabled \
  -Dwith_wayland=enabled \
  -Dmangoapp=true \
  -Dmangohudctl=true \
  -Dmangoapp_layer=true

%meson_build

%install
%meson_install

%files
%doc README.md
%doc LICENSE
%_bindir/%name
%_bindir/%{name}ctl
%dir %_libdir/%name
%_libdir/%name/libMangoHud*.so
%_man1dir/%name.1*
%_datadir/icons/hicolor/scalable/*/*.svg
%_datadir/vulkan/implicit_layer.d/*Mango*.json
%_docdir/%name/*.conf.example
%_datadir/metainfo/*.metainfo.xml

%files -n mangoapp
%_bindir/mangoapp
%_libdir/%name/libMangoApp.so
%_man1dir/mangoapp.1*

%files -n mangoplot
%_bindir/mangoplot

%changelog
