Name:    mate-menu
Version: 22.04.2
Release: alt10

Summary: An Advanced Menu for the MATE Desktop
# MIT is needed for keybinding.py
License: GPL-2.0 and MIT
Group:   Other
URL:     https://github.com/ubuntu-mate/mate-menu

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-dev
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-distutils-extra
BuildRequires: intltool

%add_python3_path %_libexecdir/%name

Requires: menu-icons-default
Requires: mate-menu-editor
Requires: altlinux-mime-defaults > 0.17
Requires: typelib(Gtk) = 3.0
Requires: python3(cairo)
Requires: python3-module-pygobject3

BuildArch: noarch

Source:  %name-%version.tar
Patch1: alt-applet-name-l10n.patch
Patch2: alt-menubutton-label-l10n.patch
Patch3: alt-use-themed-app-list.patch
Patch4: alt-set-start-button-gsettings.patch
Patch5: alt-desktop-place-fix.patch
Patch6: fix-version.patch
Patch7: alt-category-without-icon.patch
Patch8: alt-set-menubutton-tooltip-as-label.patch
Patch9: alt-fix-memory-leak-applications.patch
Patch10: alt-fix-tooltips-and-make-them-optional.patch

%description
This is MATE Menu, a fork of MintMenu. An advanced menu for MATE.
Supports filtering, favorites, autosession, and many other features.

%prep
%setup -n %name-%version
%autopatch -p1

%build
%python3_build

%install
%python3_install
%find_lang %name --with-gnome

%files -f %name.lang
%doc *.md
%_bindir/%name
%_libexecdir/%name
%_datadir/%name
%python3_sitelibdir/mate_menu/
%python3_sitelibdir/*.egg-info
%_datadir/dbus-1/services/*.service
%_datadir/glib-2.0/schemas/*.xml
%_datadir/mate-panel/applets/org.mate.panel.MateMenuApplet.mate-panel-applet
%_man1dir/%name.1*

%changelog
