Epoch: 1
Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           maven2
Version:        2.2.1
Release:        alt6_66jpp11
Summary:        Java project management and project comprehension tool
License:        ASL 2.0
URL:            http://maven.apache.org
BuildArch:      noarch

# ./generate-tarball.sh
Source0:        %{name}-%{version}.tar.gz
Source1:        generate-tarball.sh

Patch2:         %{name}-%{version}-update-tests.patch
Patch4:         %{name}-%{version}-unshade.patch
Patch5:         %{name}-%{version}-default-resolver-pool-size.patch
Patch6:         %{name}-%{version}-strip-jackrabbit-dep.patch
Patch8:         %{name}-%{version}-migrate-to-plexus-containers-container-default.patch

BuildRequires:  maven-local
BuildRequires:  mvn(org.apache.maven:maven-parent:pom:)
BuildRequires:  mvn(org.apache.maven.plugins:maven-enforcer-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-shade-plugin)
BuildRequires:  mvn(org.apache.maven.wagon:wagon-provider-api)
BuildRequires:  mvn(org.codehaus.modello:modello-maven-plugin)
BuildRequires:  mvn(org.codehaus.plexus:plexus-container-default)
BuildRequires:  mvn(org.codehaus.plexus:plexus-interpolation)
BuildRequires:  mvn(org.codehaus.plexus:plexus-utils)

Provides:       deprecated()
Source44: import.info

%description
Apache Maven is a software project management and comprehension tool.
Based on the concept of a project object model (POM), Maven can manage
a project's build, reporting and documentation from a central piece of
information.

%package -n maven-artifact
Group: Development/Java
Summary:        Compatibility Maven artifact artifact
Provides:       deprecated()

%description -n maven-artifact
Maven artifact manager artifact

%package -n maven-artifact-manager
Group: Development/Java
Summary:        Compatibility Maven artifact manager artifact
Provides:       deprecated()

%description -n maven-artifact-manager
Maven artifact manager artifact

%package -n maven-model
Group: Development/Java
Summary:        Compatibility Maven model artifact
Provides:       deprecated()

%description -n maven-model
Maven model artifact

%package -n maven-monitor
Group: Development/Java
Summary:        Compatibility Maven monitor artifact
Provides:       deprecated()

%description -n maven-monitor
Maven monitor artifact

%package -n maven-plugin-registry
Group: Development/Java
Summary:        Compatibility Maven plugin registry artifact
Provides:       deprecated()

%description -n maven-plugin-registry
Maven plugin registry artifact

%package -n maven-profile
Group: Development/Java
Summary:        Compatibility Maven profile artifact
Provides:       deprecated()

%description -n maven-profile
Maven profile artifact

%package -n maven-project
Group: Development/Java
Summary:        Compatibility Maven project artifact
Provides:       deprecated()

%description -n maven-project
Maven project artifact

%package -n maven-settings
Group: Development/Java
Summary:        Compatibility Maven settings artifact
Provides:       deprecated()

%description -n maven-settings
Maven settings artifact

%package -n maven-toolchain
Group: Development/Java
Summary:        Compatibility Maven toolchain artifact
Provides:       deprecated()

%description -n maven-toolchain
Maven toolchain artifact

%package -n maven-plugin-descriptor
Group: Development/Java
Summary:        Maven Plugin Description Model
Provides:       deprecated()

%description -n maven-plugin-descriptor
Maven plugin descriptor artifact

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{name}
Provides:       deprecated()
BuildArch: noarch

%description javadoc
Javadoc for %{name}.


%prep
%setup -q

%patch2 -b .update-tests

%patch4 -b .unshade

# disable parallel artifact resolution
%patch5 -p1 -b .parallel-artifacts-resolution

# remove unneeded jackrabbit dependency
%patch6 -p1 -b .strip-jackrabbit-dep

%patch8 -p1 -b .plexus-container

for nobuild in apache-maven maven-artifact-test \
               maven-compat maven-core maven-plugin-api \
               maven-plugin-parameter-documenter maven-reporting \
               maven-repository-metadata maven-script \
               maven-error-diagnostics; do
    %pom_disable_module $nobuild
done

# Don't install parent POM
%mvn_package :maven __noinstall

# Install all artifacts in Maven 3 directory.
%mvn_file ":{*}" maven/@1

# these parts are compatibility versions which are available in
# maven-3.x as well. We default to maven-3, but if someone asks for
# 2.x we provide few compat versions
%mvn_compat_version ":maven-{artifact,model,settings}" \
                    2.0.2 2.0.6 2.0.7 2.0.8 2.2.1

# Don't depend on backport-util-concurrent
%pom_remove_dep :backport-util-concurrent
%pom_remove_dep :backport-util-concurrent maven-artifact-manager
sed -i s/edu.emory.mathcs.backport.// `find -name DefaultArtifactResolver.java`

# Tests are skipped, so remove dependencies with scope 'test'.
for pom in $(grep -l ">test<" $(find -name pom.xml | grep -v /test/)); do
    %pom_xpath_remove "pom:dependency[pom:scope[text()='test']]" $pom
done

# Remove outdated maven-compiler-plugin configuration
%pom_xpath_remove 'pom:plugin[pom:artifactId="maven-compiler-plugin"]/pom:configuration'

%build
%mvn_build -f -s -- -P all-models -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8

%install
%mvn_install

%files -n maven-artifact -f .mfiles-maven-artifact
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-artifact-manager -f .mfiles-maven-artifact-manager
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-model -f .mfiles-maven-model
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-monitor -f .mfiles-maven-monitor
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-plugin-registry -f .mfiles-maven-plugin-registry
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-profile -f .mfiles-maven-profile
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-project -f .mfiles-maven-project
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-settings -f .mfiles-maven-settings
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-toolchain -f .mfiles-maven-toolchain
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files -n maven-plugin-descriptor -f .mfiles-maven-plugin-descriptor
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference apache-maven/LICENSE.txt apache-maven/NOTICE.txt


%changelog
