%define __nprocs 1
%define so_tls_version 19
%define so_crypto_version 14
%define so_x509_version 5
%def_disable static

Name: mbedtls
Version: 3.4.1
Release: alt1

Summary: Transport Layer Security protocol suite
License: Apache-2.0
Group: System/Libraries

Url: https://tls.mbed.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://github.com/ARMmbed/%name/archive/v%version/%name-%version.tar.gz
Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: libssl-devel
BuildRequires: python3-dev
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-mpl_toolkits

%description
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n lib%name%so_tls_version
Summary: Transport Layer Security protocol suite
Group: System/Libraries
Conflicts: hiawatha

%description -n lib%name%so_tls_version
mbed TLS is a light-weight open source cryptographic and SSL/TLS
library written in C. mbed TLS makes it easy for developers to include
cryptographic and SSL/TLS capabilities in their (embedded)
applications with as little hassle as possible.

%package -n libmbedcrypto%so_crypto_version
Summary: Cryptographic base library for mbedtls
Group: System/Libraries

%description -n libmbedcrypto%so_crypto_version
This subpackage of mbedtls contains a library that exposes
cryptographic ciphers, hashes, algorithms and format support such as
AES, MD5, SHA, Elliptic Curves, BigNum, PKCS, ASN.1, BASE64.

%package -n libmbedx509-%so_x509_version
Summary: Library to work with X.509 certificates
Group: System/Libraries
Conflicts: hiawatha < 10.10

%description -n libmbedx509-%so_x509_version
This subpackage of mbedtls contains a library that can read, verify
and write X.509 certificates, read/write Certificate Signing Requests
and read Certificate Revocation Lists.

%package -n lib%name-devel
Summary: Development files for mbed TLS
Group: Development/C
Conflicts: hiawatha

%description -n lib%name-devel
Contains libraries and header files for
developing applications that use mbed TLS

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for mbed TLS
Group: Development/C

%description -n lib%name-devel-static
Static libraries for developing applications
that use mbed TLS
%endif

%package utils
Summary: Utilities for PolarSSL
Group: Development/Tools

%description utils
Cryptographic utilities based on mbed TLS

%prep
%setup
%ifarch %e2k
# unsupported as of lcc 1.25.17
sed -i 's,-Wformat-overflow=2,,' CMakeLists.txt
%add_optflags -mno-aes
%endif

%build
%cmake .. \
	-DLIB_INSTALL_DIR:PATH=%_libdir \
	-DUSE_SHARED_MBEDTLS_LIBRARY:BOOL=TRUE \
%if_enabled static
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=TRUE
%else
	-DUSE_STATIC_MBEDTLS_LIBRARY:BOOL=FALSE
%endif

%cmake_build

%install
%cmakeinstall_std
mkdir -p %buildroot%_libexecdir/%name
mv %buildroot%_bindir/* %buildroot%_libexecdir/%name
rm -rf %buildroot%_bindir

%files -n lib%name%so_tls_version
%_libdir/lib%name.so.*

%files -n libmbedcrypto%so_crypto_version
%_libdir/libmbedcrypto.so.*

%files -n libmbedx509-%so_x509_version
%_libdir/libmbedx509.so.*

%files -n lib%name-devel
%doc ChangeLog LICENSE README.md
%dir %_includedir/%name
%_includedir/%name/*.h
%dir %_includedir/psa
%_includedir/psa/*h
%_libdir/libmbedcrypto.so
%_libdir/lib%name.so
%_libdir/libmbedx509.so
%dir %_libdir/cmake/MbedTLS
%_libdir/cmake/MbedTLS/*.cmake

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libmbedcrypto.a
%_libdir/lib%name.a
%_libdir/libmbedx509.a
%endif

%files utils
%dir %_libexecdir/%name
%_libexecdir/%name/*

%changelog
