%def_disable snapshot

%define api_ver 0.6
%define xdg_name org.midori_browser.Midori

Name: midori
Version: 9.0
Release: alt1

Summary: Midori is a lightweight web browser
License: LGPLv2.1+
Group: Networking/WWW
Url: http://www.midori-browser.org/

%if_disabled snapshot
Source: https://github.com/midori-browser/core/releases/download/v%version/%name-v%version.tar.gz
%else
# VCS: https://github.com/midori-browser/core
Source: %name-%version.tar
%endif

Requires: gcr

BuildRequires(pre): cmake
BuildRequires: gcc-c++ vala-tools intltool libappstream-glib-devel desktop-file-utils xmllint
BuildRequires: libwebkit2gtk-devel libpeas-devel libjson-glib-devel gcr-libs-devel gcr-libs-vala
BuildRequires: libarchive-devel libsoup-gnome-devel libsqlite3-devel
BuildRequires: libwebkit2gtk-gir-devel libpeas-gir-devel

%description
Midori is a lightweight yet powerful web browser which runs just as well
on little embedded computers named for delicious pastries as it does on
beefy machines with a core temperature exceeding that of planet earth.
And it looks good doing that, too. Oh, and of course it's free software.

%prep
%setup -n %name-v%version

%build
%cmake -DCMAKE_BUILD_TYPE:STRING="Release"
%cmake_build

%install
%cmakeinstall_std
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_libdir/libmidori-core.so*
%_typelibdir/Midori-%api_ver.typelib
%_desktopdir/%xdg_name.desktop
%_datadir/metainfo/%xdg_name.appdata.xml
%_iconsdir/hicolor/*/*/*.*
%doc README* CHANGELOG*

%exclude %_girdir/Midori-%api_ver.gir
%exclude %_docdir/%name

%changelog
