%def_disable clang

%define _unpackaged_files_terminate_build 1
%define _cmake__builddir BUILD
%if_enabled clang
%define optflags_lto -flto=thin
%endif

Name: mixxx
Version: 2.3.6
Release: alt3.2

Summary: Free digital DJ software
Summary(ru_RU.UTF-8): Свободная программа для цифрового диджеинга

License: GPL-2.0+
Group: Sound
Url: http://mixxx.org

# https://github.com/mixxxdj/mixxx.git
Source: %name-%version.tar

Provides: %name-data = %EVR
Obsoletes: %name-data < %EVR
Requires: qt5-sql-sqlite

BuildPreReq: rpm-macros-qt5 rpm-build-ninja
%if_enabled clang
BuildRequires: clang-devel llvm-devel-static
%else
BuildRequires: gcc-c++
%endif
BuildRequires: /proc
# BEGIN SourceDeps(oneline):
BuildRequires: libGLU-devel libX11-devel libglvnd-devel
BuildRequires: libogg-devel libprotobuf-devel protobuf-compiler
BuildRequires: libsqlite3-devel libvorbis-devel qt5-base-devel
BuildRequires: qt5-script-devel qt5-svg-devel qt5-x11extras-devel
# END SourceDeps(oneline)
BuildRequires: cmake git-core libchromaprint-devel
BuildRequires: libkeyfinder-devel libfftw3-devel libebur128-devel
BuildRequires: libflac-devel liblame-devel libportaudio2-devel
BuildRequires: libportmidi-devel librubberband-devel
BuildRequires: libsndfile-devel libsoundtouch-devel libtag-devel
BuildRequires: libupower-devel libmp4v2-devel libavcodec-devel
BuildRequires: libavformat-devel libavutil-devel libswscale-devel
BuildRequires: libswresample-devel libavdevice-devel
BuildRequires: libavfilter-devel liblilv-devel libshout-idjc-devel
BuildRequires: libmodplug-devel libopus-devel libopusfile-devel
BuildRequires: libmad-devel libid3tag-devel libqtkeychain-qt5-devel
BuildRequires: libusb-devel libhidapi-devel libwavpack-devel

%if_enabled clang
ExcludeArch: armh
%endif

%description
Mixxx is free, open source DJ software that gives you everything
you need to perform live mixes.

%description -l ru_RU.UTF-8
Mixxx - это бесплатная, с открытым исходным кодом программа для DJ,
дающая вам всё необходимое для живых выступлений.

%prep
%setup

%build
%if_enabled clang
export CC=clang
export CXX=clang++
%endif
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
chmod +x %buildroot%_datadir/mixxx/controllers/novation-launchpad/scripts/compile-mapping.js
chmod +x %buildroot%_datadir/mixxx/controllers/novation-launchpad/scripts/compile-scripts.js

%files
%_bindir/%name
%exclude %_datadir/doc
%doc README.md COPYING LICENSE res/Mixxx-Keyboard-Shortcuts.pdf
%_datadir/%name
%_datadir/metainfo/org.mixxx.Mixxx.metainfo.xml
%_desktopdir/org.mixxx.Mixxx.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/??x??/apps/%name.png
%_iconsdir/hicolor/???x???/apps/%name.png
%_udevrulesdir/69-%name-usb-uaccess.rules

%changelog
