%define shver 2.1

Name: mjpegtools
Version: 2.2.0
Release: alt1

Summary: Tools for recording, editing, playing back mpeg-encoding video under linux
License: GPLv2
Group: Video
Url: http://mjpeg.sourceforge.net

Source: http://prdownloads.sourceforge.net/mjpeg/%name-%version.tar
Patch0: mjpegtools-2.1.0-debian-disable-sse2.patch
Patch1: mjpegtools-2.2.0-debian-mplex-ftbfs.patch
Patch2: mjpegtools-2.2.0-lavtools-ftbfs.patch

%define libdv_ver 0.9

Requires: lib%name%shver = %version-%release 
Requires: libdv >= %libdv_ver

BuildPreReq: libdv-devel >= %libdv_ver

BuildRequires: glibc-kernheaders libjpeg-devel libSDL_gfx-devel gcc-c++
BuildRequires: libpng-devel libXxf86dga-devel libgtk+2-devel libSDL-devel
BuildRequires: libXt-devel libv4l-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
The MJPEG-tools are a basic set of utilities for recording, editing,
playing back and encoding (to mpeg) video under linux. Recording can
be done with zoran-based MJPEG-boards (LML33, Iomega Buz, Pinnacle
DC10(+), Marvel G200/G400), these can also playback video using the
hardware. With the rest of the tools, this video can be edited and
encoded into mpeg1/2 or divx video.

%ifarch %ix86
NOTE:
This binaries does ***NOT*** compatible with a K5/K6 or Pentium CPU
(due to the lack of SSE instructions).
%endif

%package -n lib%name%shver
Summary: Shared libraries for the mjpegtools
Group: System/Libraries
Obsoletes: %name-libs
Provides: %name-libs = %version-%release

%description -n lib%name%shver
This package contains shared libraries needed to run mjpegtools.

%ifarch %ix86
NOTE:
This binaries does ***NOT*** compatible with a K5/K6 or Pentium CPU
(due to the lack of SSE instructions).
%endif

%package -n lib%name-devel
Summary: Development headers and libraries for the mjpegtools
Group: Development/C
Obsoletes: %name-devel
Provides: %name-devel = %version-%release
Requires: lib%name%shver = %version-%release

%description -n lib%name-devel
This package contains libraries and header files needed to compile
applications that use part of the libraries of the mjpegtools package.

%package -n lib%name-devel-static
Summary: Static libraries for the mjpegtools
Group: Development/C
Obsoletes: %name-static-libs
Provides: %name-static-libs = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static libraries needed to compile applications
that use part of the libraries of the mjpegtools package.

%ifarch %ix86
NOTE:
This binaries does ***NOT*** compatible with a K5/K6 or Pentium CPU
(due to the lack of SSE instructions).
%endif

%prep
%setup
%ifnarch %ix86 x86_64
%patch0 -p1
%endif
%patch1 -p1
%patch2 -p1

%build
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-large-file \
	--with-x \
%ifarch %ix86 x86_64
	--enable-simd-accel
%else
	--disable-simd-accel
%endif

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
export LD_LIBRARY_PATH=$PWD/utils/.libs
%make_build

%install
%makeinstall

sed -i 's,local/bin/,/bin/,' %buildroot%_bindir/*.sh

# remove non-packaged files
rm -f %buildroot%_infodir/dir

%files
%_bindir/*
%_man1dir/*
%_infodir/*.info*
%doc AUTHORS BUGS CHANGES HINTS PLANS README TODO

%files -n lib%name%shver
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%_man5dir/*

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
