%define clang_arches %ix86 x86_64 aarch64 ppc64el armh mipsel

Name: mk-configure
Version: 0.37.0
Release: alt1

Summary: Lightweight replacement for GNU autotools
License: BSD-2-Clause and MIT and ISC
Group: Development/Tools

Url: http://sourceforge.net/projects/mk-configure/
# Source-url: http://prdownloads.sf.net/%name-%version/%name-%version.tar.bz2
Source: %name-%version.tar
Source1: %name.macros

Packager: Aleksey Cheusov <cheusov@altlinux.org>

BuildArch: noarch

Requires:      bmake bmkdep
BuildRequires: bmake mk-files binutils

Requires: rpm-macros-%name = %version-%release

%filter_from_requires /xpg4/d

# required for %%check
BuildRequires: flex bison gcc-c++ glib2-devel groff-base zlib-devel libbsd-devel bmkdep
BuildRequires: perl-podlators perl-devel lua-devel info-install makeinfo m4

%ifarch %clang_arches
BuildRequires: clang
%define cc_compilers gcc clang
%define cxx_compilers g++ clang++
%else
%define cc_compilers gcc
%define cxx_compilers g++
%endif

%define pkgdocdir %_docdir/%name-%version

%description
mk-configure is a lightweight replacement for GNU autotools, written in
bmake (portable version of NetBSD make) and POSIX tools.

%package doc
Summary: %name documentation
Group: Development/Documentation

%description doc
Examples and presentation for %name package.

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging applications that use mk-configure
Group: Development/Other

%description -n rpm-macros-%name
Set of RPM macros for packaging applications that use mk-configure.

%prep
%setup

%define env \
  unset MAKEFLAGS; \
  export USE_NM=%_bindir/nm \
  export USE_INSTALL=%__install \
  export USE_AWK=%_bindir/awk \
  export USE_ID=%_bindir/id \
  export USE_CC_COMPILERS='%cc_compilers' \
  export USE_CXX_COMPILERS='%cxx_compilers' \
  export PREFIX=%_prefix \
  export SYSCONFDIR=%_sysconfdir \
  export MANDIR=%_mandir

# examples are built and tested either,
# let's keep a pristine copy
cp -al examples doc

%build
%env
bmake all

%install
%env
bmake install DESTDIR=%buildroot
install -pD -m644 %SOURCE1 %buildroot%_rpmmacrosdir/%name
rm -rf %buildroot%_docdir/%name

# instead of proper %%doc (share docdir among subpackages)
mkdir -p %buildroot%pkgdocdir
cp -at %buildroot%pkgdocdir -- \
	doc/FAQ doc/LICENSE doc/NEWS doc/NOTES README* \
	doc/examples/ presentation/presentation.pdf

%check
export PATH="/sbin:$PATH" # /sbin/info-install
unset MAKEFLAGS
# The following tests are disabled because
# lua.pc does not provide INSTALL_{C,L}MOD
export NOSUBDIR='hello_lua hello_lua2 hello_lua3 lua_dirs'
bmake test
bmake -k cleandir-examples
bmake -k cleandir-tests

%files
%dir %pkgdocdir
%pkgdocdir/[A-Z]*
%_bindir/*
%_datadir/%name/
%_man1dir/*
%_man7dir/*
%_prefix/libexec/%name

%files doc
%dir %pkgdocdir
%pkgdocdir/examples/
%pkgdocdir/presentation.pdf

%files -n rpm-macros-%name
%_rpmmacrosdir/%name

# TODO:
# - add %%config %%_sysconfdir/rpm/macros.mkcmake (extra source)

%changelog
