%define set_disable() %{expand:%%force_disable %1} %{expand:%%undefine _enable_%1}
%define set_enable() %{expand:%%force_enable %1} %{expand:%%undefine _disable_%1}
%define mIF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define mIF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define mIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define mIF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"

%define is_ffmpeg %([ -n "`rpmquery --qf '%%{SOURCERPM}' libavformat-devel 2>/dev/null | grep -e '^libav'`" ] && echo 0 || echo 1)

%def_disable debug
%def_enable libvidstab

%define Name MLT
%define mlt_sover 6
%define libmlt libmlt%mlt_sover
%define mltxx_sover 3
%define libmltxx libmlt++%mltxx_sover

Name: mlt
Version: 6.26.1
Release: alt3

Summary: Multimedia framework designed for television broadcasting
License: GPL-3.0-or-later
Group: Video
Url: https://www.mltframework.org/

Packager: Maxim Ivanov <redbaron@altlinux.org>

Source: %name-%version.tar
Source1: mlt++-config.h
# Debian
Patch20: 01-changed-preset-path.diff
# ALT
Patch101: alt-configure-mmx.patch
Patch102: alt-no-version-script.patch
Patch103: alt-libav.patch

# Automatically added by buildreq on Sun Mar 18 2018 (-bi)
# optimized out: elfutils gcc-c++ glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libGL-devel libSDL-devel libX11-devel libavcodec-devel libavformat-devel libavutil-devel libcdio-paranoia libdc1394-22 libgpg-error libopencore-amrnb0 libopencore-amrwb0 libp11-kit libqt5-core libqt5-gui libqt5-svg libqt5-widgets libqt5-xml libraw1394-11 libstdc++-devel libvdpau-devel libx265-130 perl pkg-config python-base python-devel python-modules qt5-base-devel rpm-build-gir swig-data xorg-xproto-devel
#BuildRequires: frei0r-devel ladspa_sdk libSDL2-devel libSDL2_image-devel libalsa-devel libavdevice-devel libavfilter-devel libexif-devel libfftw3-devel libjack-devel libopencv-devel libpulseaudio-devel libsamplerate-devel libsox-devel libswscale-devel libxml2-devel qt5-svg-devel swig
#BuildRequires: frei0r-devel ladspa_sdk libSDL_image-devel libalsa-devel libavdevice-devel libavformat-devel libexif-devel libfftw3-devel libjack-devel libpulseaudio-devel libsamplerate-devel libsox-devel libswfdec-devel libswscale-devel libxml2-devel python-module-google python3-dev qt5-svg-devel rpm-build-ruby swig
BuildRequires(pre): rpm-build-kf5 rpm-build-python3 libavformat-devel
BuildRequires: qt5-svg-devel
BuildRequires: frei0r-devel libSDL-devel libSDL2-devel libSDL2_image-devel libalsa-devel libexif-devel
BuildRequires: libavfilter-devel libswscale-devel libavdevice-devel libavformat-devel
%if %is_ffmpeg
BuildRequires: libswresample-devel
%endif
BuildRequires: libfftw3-devel libjack-devel libpulseaudio-devel libsamplerate-devel libsox-devel
BuildRequires: librubberband-devel libvorbis-devel
BuildRequires: libxml2-devel swig ladspa_sdk
%if_enabled libvidstab
BuildRequires: libvidstab-devel
%endif
BuildRequires: python3-devel
BuildRequires: libgdk-pixbuf-devel libpango-devel

%description
%Name is a multimedia framework designed for television broadcasting.

%package utils
Summary: %name utils
Group: Video
License: GPL
%description utils
%Name utils.

%package -n %libmlt
Summary: %Name framework library
License: GPL
Group: System/Libraries
%mIF_ver_lt %version 7
Provides: libmlt = %EVR
Obsoletes: libmlt < %EVR
%endif
%description -n %libmlt
%Name is a multimedia framework designed for television broadcasting.

%package -n %libmltxx
Summary: C++ wrapping for the MLT library
Group: System/Libraries
%mIF_ver_lt %version 7
Provides: libmlt++ = %EVR
Obsoletes: libmlt++ < %EVR
%endif
%description -n %libmltxx
This mlt sub-project provides a C++ wrapping for the MLT library.

%package -n libmlt-devel
Summary: Development files for %Name framework
License: GPL
Group: Development/C
%description -n libmlt-devel
Development files for %Name framework.

%package -n libmlt++-devel
Summary: Development files for %Name
Group: Development/C++
%description -n libmlt++-devel
Development files for %Name.

%package -n python3-module-%name
Summary: Python package to work with %Name
Group: Development/Python
%description -n python3-module-%name
This module allows to work with %Name using python..

%prep
%setup
%if %is_ffmpeg
%else
%patch20 -p1
%endif
%patch101 -p1
%patch102 -p1
%if %is_ffmpeg
%else
%patch103 -p1
%endif

[ -f src/mlt++/config.h ] || \
    install -m 0644 %SOURCE1 src/mlt++/config.h

find src/swig/python -name '*.py' | xargs sed -i '1s|^#!/usr/bin/env python|#!%{__python3}|'
sed -i -e 's|which python|which python3|' src/swig/python/build
sed -i -e 's|python -c|python3 -c|' src/swig/python/build
sed -i -e 's|python-config|python3-config|' src/swig/python/build
sed -i -e 's|python{}.{}|python{}.{}m|' src/swig/python/build

%ifarch %e2k
sed -i 's,-fno-tree-pre,,' configure
%endif

%build
%mIF_ver_lt %_qt5_version 5.9
%add_optflags -std=c++11
%endif
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
export CC=gcc CXX=g++ CFLAGS="%optflags" QTDIR=%_qt5_prefix
%configure \
	--enable-gpl --enable-gpl3 \
	--target-os=Linux \
%ifarch x86_64
	--target-arch=%_target_cpu \
%endif
	%ifnarch %ix86 x86_64
	--disable-mmx \
	--disable-sse \
	--disable-sse2 \
	%endif
	%ifarch i586
	--disable-mmx \
	%endif
	%{subst_enable debug} \
	--without-kde \
	--kde-includedir=%_K5inc \
        --kde-libdir=%_K5link \
        --swig-languages=python \
        --disable-swfdec \
        --disable-opencv \
        #
#	--luma-compress \

%make_build

%install
%makeinstall_std
install -d %buildroot/%python3_sitelibdir
install -pm 0644 src/swig/python/%name.py %buildroot/%python3_sitelibdir/
install -pm 0755 src/swig/python/_%name.so %buildroot/%python3_sitelibdir/

#%files -n %name-utils
#%doc docs/melt.txt
#%_bindir/melt

%files -n %libmlt
#%doc docs/services.txt docs/westley.txt
%_libdir/libmlt.so.%mlt_sover
%_libdir/libmlt.so.*
%_libdir/mlt
%_datadir/mlt

%files -n %libmltxx
%_libdir/libmlt++.so.%mltxx_sover
%_libdir/libmlt++.so.*

%files -n python3-module-%name
%python3_sitelibdir/*

%files -n libmlt-devel
#%doc docs/framework.txt
%_includedir/mlt/
%_libdir/libmlt.so
%_pkgconfigdir/mlt-framework.pc

%files -n libmlt++-devel
%_includedir/mlt++/
%_libdir/libmlt++.so
%_pkgconfigdir/mlt++.pc

%changelog
