%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: mongo6.0
Version: 6.0.26
Release: alt0.p10.1
Summary: mongo server, sharding server,  and support scripts
License: SSPL-1.0
Group: Development/Databases
Url: https://www.mongodb.org
Source: %name-%version.tar
Patch0: mongo6.0-6.0.11-debuginfo.patch

# From https://docs.mongodb.com/manual/installation
# Changed in version 3.4: MongoDB no longer supports 32-bit x86 platforms.
ExclusiveArch: x86_64 aarch64 ppc64le %e2k

BuildRequires(pre): rpm-macros-valgrind

BuildRequires: /proc gcc10-c++ gcc10 python3-module-pymongo python3-module-pkg_resources
BuildRequires: libssl-devel libpcre-devel libpcrecpp-devel libreadline-devel
BuildRequires: libpcap-devel libsnappy-devel
BuildRequires: systemd-devel libgperftools-devel libsasl2-devel libstemmer-devel
BuildRequires: libyaml-cpp-devel zlib-devel python-modules-json
BuildRequires: python3-module-Cheetah python3-module-yaml python3-module-psutil
BuildRequires: libcurl-devel python3-module-packaging
BuildRequires: liblzma-devel

%if_enabled valgrind
BuildRequires: valgrind-devel
%endif

BuildRequires: python3-module-bson
BuildRequires: python3-module-idna
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-memory_profiler
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-typing_extensions

%description
Mongo (from "huMONGOus") is a schema-free document-oriented database.
It features dynamic profileable queries, full indexing, replication
and fail-over support, efficient storage of large binary data objects,
and auto-sharding.

This package provides the mongo shell.

%package server-mongod
Summary: mongo server, sharding server,  and support scripts
Group: Development/Databases
Provides: mongo-server
Obsoletes: mongo-server

Provides: mongo-server-mongod = %EVR
Conflicts: mongo-server-mongod < %EVR
Conflicts: mongo-server-mongod > %EVR

%description server-mongod
Mongo (from "huMONGOus") is a schema-free document-oriented database.

mongod is the primary daemon process for the MongoDB system.
It handles data requests, manages data format,
and performs background management operations.

%package server-mongos
Summary: mongo routing service, and support scripts
Group: Development/Databases
Provides: mongo-server-mongos = %EVR
Conflicts: mongo-server-mongos < %EVR
Conflicts: mongo-server-mongos > %EVR

%description server-mongos
Mongo (from "huMONGOus") is a schema-free document-oriented database.

mongos for "MongoDB Shard," is a routing service for MongoDB shard
configurations that processes queries from the application layer,
and determines the location of this data in the sharded cluster,
in order to complete these operations. From the perspective of the
application, a mongos instance behaves identically to any other
MongoDB instance.

%prep
%setup
%patch0 -p1

%build
%ifarch aarch64
%define ccflags_arch_opts "-march=armv8-a+crc"
%endif

%ifarch %e2k
%define opt_wt --wiredtiger=off
%else
%define opt_wt --wiredtiger=on
%endif
%define build_opts \\\
       -j 8 \\\
       --use-system-tcmalloc \\\
       --use-system-pcre \\\
       --use-system-snappy \\\
       %{?_enable_valgrind:--use-system-valgrind} \\\
       --use-system-zlib \\\
       --use-system-stemmer \\\
       --use-system-yaml \\\
       --use-sasl-client \\\
       %opt_wt \\\
       --ssl=on \\\
       --release \\\
       MONGO_VERSION="%{version}-%{release}" \\\
       --disable-warnings-as-errors \\\
       CCFLAGS="%{?optflags} %{?ccflags_arch_opts} `pkg-config --cflags libpcrecpp`"

python3 src/third_party/scons-3.1.2/scons.py CC=gcc-10 CXX=g++-10 %build_opts

%install
# cow@: It seems that mongo 4.2 + scons 3.1.1 doesn't provide a clean way to
# specify location to install binaries (at least I wasn't able to find it).
install -p -D -m 755 build/install/bin/mongod %buildroot%_bindir/mongod
install -p -D -m 755 build/install/bin/mongos %buildroot%_bindir/mongos

mkdir -p %buildroot%_logdir/mongo
mkdir -p %buildroot%_runtimedir/mongo
mkdir -p %buildroot%_localstatedir/mongo
mkdir -p %buildroot%_man1dir
cp debian/{mongod,mongos}.1 %buildroot%_man1dir/

#mongod
install -p -D -m 644 mongod.logrotate %buildroot%_logrotatedir/mongod
install -p -D -m 755 mongod.init.alt %buildroot%_initddir/mongod
install -p -D -m 644 mongod.conf %buildroot%_sysconfdir/mongo/mongod.conf
install -p -D -m 644 mongod.sysconf %buildroot%_sysconfdir/sysconfig/mongod
install -p -D -m 644 mongod.service %buildroot%_unitdir/mongod.service
install -p -D -m 644 mongod.tmpfile %buildroot%_tmpfilesdir/mongod.conf

#mongos
install -p -D -m 644 mongos.logrotate %buildroot%_logrotatedir/mongos
install -p -D -m 755 mongos.init.alt %buildroot%_initddir/mongos
install -p -D -m 644 mongos.conf %buildroot%_sysconfdir/mongo/mongos.conf
install -p -D -m 644 mongod.sysconf %buildroot%_sysconfdir/sysconfig/mongos
install -p -D -m 644 mongos.service %buildroot%_unitdir/mongos.service
install -p -D -m 644 mongod.tmpfile %buildroot%_tmpfilesdir/mongos.conf

# cow@: Mongo fails to build on Alt Beekeeper machine because there are only 32GB
# of a disk space is available. Right now we reach this limit during the generation
# of debuginfo files. Let's try to hotfix this issue by removing files created during
# the build process.
rm -fr build

%pre server-mongod
%_sbindir/groupadd -r -f mongod ||:
%_sbindir/useradd -r -n -g mongod -d /var/lib/mongo -s /bin/false -c "Mongod pseudo user" mongod >/dev/null 2>&1 ||:

%post server-mongod
%post_service mongod

%preun server-mongod
%preun_service mongod

%pre server-mongos
%_sbindir/groupadd -r -f mongod ||:
%_sbindir/useradd -r -n -g mongod -d /var/lib/mongo -s /bin/false -c "Mongod pseudo user" mongod >/dev/null 2>&1 ||:

%post server-mongos
%post_service mongos

%preun server-mongos
%preun_service mongos

%files server-mongod
%doc README.md LICENSE-Community.txt
%config(noreplace) %_sysconfdir/mongo/mongod.conf
%config(noreplace) %_sysconfdir/sysconfig/mongod
%config(noreplace) %_logrotatedir/mongod
%_bindir/mongod
%_man1dir/mongod.1*
%_initdir/mongod
%systemd_unitdir/mongod.service
%_tmpfilesdir/mongod.conf
%attr(0750,mongod,mongod) %dir %_localstatedir/mongo
%attr(1770,root,mongod) %dir %_logdir/mongo
%attr(0750,mongod,mongod) %dir %_runtimedir/mongo

%files server-mongos
%doc README.md LICENSE-Community.txt
%config(noreplace) %_sysconfdir/mongo/mongos.conf
%config(noreplace) %_sysconfdir/sysconfig/mongos
%config(noreplace) %_logrotatedir/mongos
%_bindir/mongos
%_man1dir/mongos.1*
%_initdir/mongos
%systemd_unitdir/mongos.service
%_tmpfilesdir/mongos.conf
%attr(1770,root,mongod) %dir %_logdir/mongo
%attr(0750,mongod,mongod) %dir %_runtimedir/mongo

%changelog
