%define docver 3.49.03

Summary: Painting program for creating icons and pixel-based artwork
Name: mtpaint
Version: 3.50
Release: alt1
License: GPL-3.0+
Group: Graphics
Url: http://mtpaint.sourceforge.net/
Source: %name-%version.tar.bz2
Source1: http://downloads.sf.net/%name/%{name}_handbook-%docver.zip
Patch1: %name-xdg-open.patch
Patch2: %name-openjpeg.patch

# Automatically added by buildreq on Tue Apr 06 2021
# optimized out: at-spi2-atk fontconfig glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 libX11-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libharfbuzz-devel libpango-devel libpng-devel libwayland-client libwayland-cursor libwayland-egl pkg-config python2-base sh4 xorg-proto-devel zlib-devel
BuildRequires: libgif-devel libgtk+3-devel libjpeg-devel libtiff-devel unzip

BuildRequires: gtk2-devel zlib-devel unzip
BuildRequires: libpng-devel libungif-devel libjpeg-devel libtiff-devel
BuildRequires: desktop-file-utils gettext dos2unix

Requires: %name-handbook

%description
mtPaint is a simple painting program designed for creating icons and
pixel-based artwork. It can edit indexed palette or 24 bit RGB images
and offers basic painting and palette manipulation tools. Its main
file format is PNG, although it can also handle JPEG, GIF, TIFF, BMP,
XPM, and XBM files.

%package handbook
Summary: Handbook for the mtpaint painting application
Group: Graphics
License: GFDL
Buildarch: noarch
Requires: %name = %version-%release

%description handbook
Install this package is want to read the handbook for the painting
application mtpaint.

%prep
%setup -a 1
%patch1 -p2
%patch2 -p2

%build
# This is not a "normal" configure
CFLAGS=-fcommon ./configure --datarootdir=%_datadir \
	cflags asneeded debug intl man gtk3 tiff jpeg GIF
sed -i "s/ -ggdb/ -fcommon -ggdb/" _conf.txt
%make_build

%install
%makeinstall MT_PREFIX=%buildroot%prefix            \
                  MT_MAN_DEST=%buildroot%_mandir     \
		  MT_DATAROOT=%buildroot%_datadir \
                  MT_LANG_DEST=%buildroot%_datadir/locale \
                  BIN_INSTALL=%buildroot%_bindir

desktop-file-install --delete-original         \
    --vendor "" \
    --dir %buildroot%_datadir/applications \
    %buildroot%_datadir/applications/%name.desktop

mkdir -p %buildroot%_defaultdocdir/%name
cp -a %{name}_handbook-%docver/docs/* %buildroot%_defaultdocdir/%name

%find_lang %name

%files -f %name.lang
%doc COPYING NEWS README
%_bindir/%name
%_man1dir/%name.1*
%_desktopdir/*.desktop
%_datadir/pixmaps/%name.png

%files handbook
%_defaultdocdir/%name/

%changelog
