Group: Development/Java
%filter_from_requires /^.usr.bin.run/d
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 2.4.10
%global namedreltag .Final
%global namedversion %{version}%{?namedreltag}

Name:          mvel
Version:       2.4.10
Release:       alt1_1jpp11
Summary:       MVFLEX Expression Language
License:       ASL 2.0
Url:           https://github.com/mvel
Source0:       https://github.com/mvel/mvel/archive/%{name}2-%{namedversion}.tar.gz
Source1:       %{name}-script
Patch0:        0-use-system-asm.patch
# remove tests which require internal objectweb-asm libraries
Patch1:        1-remove-internal-asm-tests.patch
Patch2:        2-remove-underscore-identifier.patch

BuildRequires: maven-local
BuildRequires: mvn(com.thoughtworks.xstream:xstream)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-enforcer-plugin)
BuildRequires: mvn(org.apache.maven.plugins:maven-surefire-report-plugin)
BuildRequires: mvn(org.ow2.asm:asm)
BuildRequires: mvn(org.ow2.asm:asm-util)
# Explicit requires for javapackages-tools since mvel script
# uses /usr/share/java-utils/java-functions
Requires:      javapackages-tools

BuildArch:     noarch
Source44: import.info

%description
MVEL is a powerful expression language for Java-based applications. It
provides a plethora of features and is suited for everything from the
smallest property binding and extraction, to full blown scripts.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n %{name}-%{name}2-%{namedversion}
find . -name "*.jar" -delete
find . -name "*.class" -delete

rm ASM-LICENSE.txt

%patch0 -p1
rm -rf src/main/java/org/mvel2/asm
%patch1 -p1
%patch2 -p1


# Unwanted task
%pom_remove_plugin :maven-source-plugin
# Remove org.apache.maven.wagon:wagon-webdav:1.0-beta-2
%pom_xpath_remove "pom:project/pom:build/pom:extensions"

sed -i 's/\r//' LICENSE.txt

%mvn_file :%{name}2 %{name}

%build

# Tests fails only on ARM builder
%mvn_build -f -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

mkdir -p %{buildroot}%{_bindir}
install -pm 755 %{SOURCE1} %{buildroot}%{_bindir}/%{name}

mkdir -p $RPM_BUILD_ROOT`dirname /etc/mvel.conf`
touch $RPM_BUILD_ROOT/etc/mvel.conf

%files -f .mfiles
%{_bindir}/%{name}
%doc --no-dereference LICENSE.txt
%config(noreplace,missingok) /etc/mvel.conf

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
