%define _unpackaged_files_terminate_build 1

Name: nheko
Version: 0.8.2
Release: alt0.p10.1

Summary: Desktop client (QT) for the Matrix protocol

Group: Development/Other
License: GPLv3
Url: https://github.com/Nheko-Reborn/nheko.git

Source: %name-%version.tar
Patch: nheko-0.8.2-p10.1-alt-fix-compilation.patch

BuildRequires: cmake gcc-c++
BuildRequires: qt5-tools-devel qt5-multimedia-devel qt5-svg-devel
BuildRequires: qt5-declarative-devel qt5-quickcontrols2-devel
BuildRequires: libqtkeychain-qt5-devel
BuildRequires: boost-asio-devel boost-devel-headers boost-signals-devel
BuildRequires: libssl-devel zlib-devel libtweeny-devel liblmdbxx-devel
BuildRequires: libmtxclient-devel liblmdb-devel cmark-devel
BuildRequires: nlohmann-json-devel libfmt-devel
BuildRequires: libolm-devel libsodium-devel libspdlog-devel
BuildRequires: gst-plugins-bad-devel gst-plugins-devel
BuildRequires: libpcre-devel
BuildRequires: libmount-devel
BuildRequires: libblkid-devel
BuildRequires: libuuid-devel
BuildRequires: libselinux-devel

# Additional (runtime) dependencies
Requires: qt5-graphicaleffects qt5-quickcontrols2 qt5-multimedia

%description
The motivation behind the project is to provide a native desktop app
for Matrix that feels more like a mainstream chat app (Riot, Telegram etc)
and less like an IRC client.

%prep
%setup
%patch -p2

%build
%cmake -DUSE_BUNDLED_BOOST=OFF  \
       -DUSE_BUNDLED_SPDLOG=OFF \
       -DUSE_BUNDLED_OLM=OFF    \
       -DUSE_BUNDLED_CMARK=OFF  \
       -DUSE_BUNDLED_LMDBXX=OFF \
       -DUSE_BUNDLED_TWEENY=OFF \
       -DUSE_BUNDLED_MATRIX_CLIENT=OFF \
       -DCMAKE_BUILD_TYPE=Release

# Adjust nprocs for git.alt
[ ${NPROCS:-%__nprocs} -le 16 ] || NPROCS=16
%cmake_build

%install
%cmakeinstall_std

%files
%doc README.md COPYING
%_bindir/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/*.appdata.xml

%changelog
