Epoch: 0
Group: Development/Java
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-1.8-compat
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_without junit5
%bcond_without osgi

Name:           objectweb-asm
Version:        8.0.1
Release:        alt1_1jpp8
Summary:        Java bytecode manipulation and analysis framework
License:        BSD
URL:            http://asm.ow2.org/
BuildArch:      noarch

# ./generate-tarball.sh
Source0:        %{name}-%{version}.tar.gz
Source1:        parent.pom
Source2:        https://repo1.maven.org/maven2/org/ow2/asm/asm/%{version}/asm-%{version}.pom
Source3:        https://repo1.maven.org/maven2/org/ow2/asm/asm-analysis/%{version}/asm-analysis-%{version}.pom
Source4:        https://repo1.maven.org/maven2/org/ow2/asm/asm-commons/%{version}/asm-commons-%{version}.pom
Source5:        https://repo1.maven.org/maven2/org/ow2/asm/asm-test/%{version}/asm-test-%{version}.pom
Source6:        https://repo1.maven.org/maven2/org/ow2/asm/asm-tree/%{version}/asm-tree-%{version}.pom
Source7:        https://repo1.maven.org/maven2/org/ow2/asm/asm-util/%{version}/asm-util-%{version}.pom
# We still want to create an "all" uberjar, so this is a custom pom to generate it
# TODO: Fix other packages to no longer depend on "asm-all" so we can drop this
Source8:        asm-all.pom
# The source contains binary jars that cannot be verified for licensing and could be proprietary
Source9:       generate-tarball.sh

# Revert upstream change https://gitlab.ow2.org/asm/asm/-/commit/2a58bc9bcf2ea6eee03e973d1df4cf9312573c9d
# To restore some deprecations that were deleted and broke the API
Patch0: 0001-Revert-upstream-change-2a58bc9.patch

# Move a statement that can throw a CompileException inside a try-catch block
# for that exception.  Upstream has fixed this another way with a large code
# refactor that seems inappropriate to backport.
Patch1: 0002-Catch-CompileException-in-test.patch

BuildRequires:  maven-local
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-shade-plugin)
BuildRequires:  mvn(org.ow2:ow2:pom:)
%if %{with junit5}
BuildRequires:  mvn(org.codehaus.janino:janino)
BuildRequires:  mvn(org.junit.jupiter:junit-jupiter-api)
BuildRequires:  mvn(org.junit.jupiter:junit-jupiter-engine)
BuildRequires:  mvn(org.junit.jupiter:junit-jupiter-params)
BuildRequires:  mvn(org.apache.maven.surefire:surefire-junit-platform)
%endif

%if %{with osgi}
# asm-all needs to be in pluginpath for BND.  If this self-dependency
# becomes a problem then ASM core will have to be build from source
# with javac before main maven build, just like bnd-module-plugin
BuildRequires:  objectweb-asm >= 6
%endif

# Explicit javapackages-tools requires since asm-processor script uses
# /usr/share/java-utils/java-functions
Requires:       javapackages-tools
Source44: import.info

%description
ASM is an all purpose Java bytecode manipulation and analysis
framework.  It can be used to modify existing classes or dynamically
generate classes, directly in binary form.  Provided common
transformations and analysis algorithms allow to easily assemble
custom complex transformations and code analysis tools.

%package        javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description    javadoc
This package provides %{summary}.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


# A custom parent pom to aggregate the build
cp -p %{SOURCE1} pom.xml

%if %{without junit5}
%pom_disable_module asm-test
%endif

# Insert poms into modules
for pom in asm asm-analysis asm-commons asm-test asm-tree asm-util; do
  cp -p $RPM_SOURCE_DIR/${pom}-%{version}.pom $pom/pom.xml
  # Fix junit5 configuration
%if %{with junit5}
  %pom_add_dep org.junit.jupiter:junit-jupiter-engine:5.1.0:test $pom
  %pom_add_plugin org.apache.maven.plugins:maven-surefire-plugin:2.22.0 $pom
%endif
%if %{with osgi}
  if [ "$pom" != "asm-test" ] ; then
    # Make into OSGi bundles
    bsn="org.objectweb.${pom//-/.}"
    %pom_xpath_inject pom:project "<packaging>bundle</packaging>" $pom
    %pom_add_plugin org.apache.felix:maven-bundle-plugin:3.5.0 $pom \
"   <extensions>true</extensions>
    <configuration>
      <instructions>
        <Bundle-SymbolicName>$bsn</Bundle-SymbolicName>
        <Bundle-RequiredExecutionEnvironment>JavaSE-1.8</Bundle-RequiredExecutionEnvironment>
        <_removeheaders>Bnd-LastModified,Build-By,Created-By,Include-Resource,Require-Capability,Tool</_removeheaders>
        <_pluginpath>$(pwd)/tools/bnd-module-plugin/bnd-module-plugin.jar, $(find-jar objectweb-asm/asm-all)</_pluginpath>
        <_plugin>org.objectweb.asm.tools.ModuleInfoBndPlugin;</_plugin>
      </instructions>
    </configuration>"
  fi
%endif
done

# Disable tests that use unlicensed class files
sed -i -e '/testToByteArray_computeMaxs_largeSubroutines/i@org.junit.jupiter.api.Disabled("missing class file")' \
  asm/src/test/java/org/objectweb/asm/ClassWriterTest.java
sed -i -e '/testAnalyze_mergeWithJsrReachableFromTwoDifferentPaths/i@org.junit.jupiter.api.Disabled("missing class file")' \
  asm-analysis/src/test/java/org/objectweb/asm/tree/analysis/AnalyzerWithBasicInterpreterTest.java
sed -i -e '/testAllMethods_issue317586()/i@org.junit.jupiter.api.Disabled("missing class file")' \
  asm-commons/src/test/java/org/objectweb/asm/commons/LocalVariablesSorterTest.java

# Remove failing test SerialVersionUidAdderTest due to missing class files
rm asm-commons/src/test/java/org/objectweb/asm/commons/SerialVersionUidAdderTest.java

# Insert asm-all pom
mkdir -p asm-all
sed 's/@VERSION@/%{version}/g' %{SOURCE8} > asm-all/pom.xml

# Remove invalid self-dependency
%pom_remove_dep org.ow2.asm:asm-test asm-test

# Compat aliases
%mvn_alias :asm-all org.ow2.asm:asm-debug-all

# No need to ship the custom parent pom
%mvn_package :asm-aggregator __noinstall
# Don't ship the test framework to avoid runtime dep on junit
%mvn_package :asm-test __noinstall

%build
# Must compile bnd plugin first, which is used to generate Java 9 module-info.class files
pushd tools/bnd-module-plugin
javac -sourcepath ../../asm/src/main/java/ -cp $(build-classpath aqute-bnd) $(find -name *.java)
jar cf bnd-module-plugin.jar -C src/main/java org
popd

%if %{with junit5}
%mvn_build -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8
%else
%mvn_build -f -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8
%endif

%install
%mvn_install

%jpackage_script org.objectweb.asm.xml.Processor "" "" %{name}/asm:%{name}/asm-attrs:%{name}/asm-util %{name}-processor true

%files -f .mfiles
%doc --no-dereference LICENSE.txt
%{_bindir}/%{name}-processor

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE.txt

%changelog
