%define oname base
Name: ocaml-%oname
Version: 0.14.1
Release: alt1
Summary: Full standard library replacement for OCaml
License: Apache-2.0
Group: Development/ML
Url: https://github.com/janestreet/%oname
Source0: %name-%version.tar
BuildRequires: ocaml
BuildRequires: ocaml-findlib
BuildRequires: ocaml-dune-configurator-devel
BuildRequires: ocaml-sexplib0-devel  >= 0.12

%description
Base is a complete and portable alternative to the OCaml standard
library. It provides all standard functionalities one would expect
from a language standard library. It uses consistent conventions
across all of its module.

Base aims to be usable in any context. As a result system dependent
features such as I/O are not offered by Base. They are instead
provided by companion libraries such as stdio.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
%dune_build -p %oname

%install
%dune_install

%check
%dune_check

%files -f ocaml-files.runtime
%doc README.org LICENSE.md
%_libdir/ocaml/%oname/runtime.js
%_libdir/ocaml/%oname/base_internalhash_types/runtime.js

%files devel -f ocaml-files.devel
%_libdir/ocaml/%oname/base_internalhash_types/internalhash.h

%changelog
