%def_with check
Name: ocaml-dose3
Version: 7.0.0
Release: alt1
Summary: Framework for managing distribution packages and dependencies
Group: Development/ML

%global libname %(echo %name | sed -e 's/^ocaml-//')

# Linking exception, see included COPYING file.
License: LGPLv3+ with OCaml-LGPL-linking-exception
Url: http://www.mancoosi.org/software/

Source0: %name-%version.tar

BuildRequires: ocaml
BuildRequires: dune
BuildRequires: ocaml-ocamldoc
BuildRequires: ocaml-ocamlgraph-devel
BuildRequires: ocaml-findlib-devel
BuildRequires: ocaml-extlib-devel
BuildRequires: ocaml-expat-devel
BuildRequires: ocaml-xml-light-devel
BuildRequires: ocaml-re-devel
BuildRequires: ocaml-cudf-devel
BuildRequires: ocaml-cppo
BuildRequires: ocaml-curl
BuildRequires: ocaml-zip-devel
BuildRequires: ocaml-camlbz2-devel
BuildRequires: ocaml-base64-devel
BuildRequires: ocaml-parmap-devel
BuildRequires: ocaml-ounit-devel
BuildRequires: ocaml-odoc
%if_with check
BuildRequires: /usr/bin/dpkg 
BuildRequires: python3-module-yaml
%endif
BuildRequires: rpm-devel
BuildRequires: zlib-devel
BuildRequires: perl

# Depend on pod2man, pod2html.
BuildRequires: /usr/bin/pod2man
BuildRequires: /usr/bin/pod2html

%description
Dose3 is a framework made of several OCaml libraries for managing
distribution packages and their dependencies.

Though not tied to any particular distribution, dose3 constitutes a pool of
libraries which enable analyzing packages coming from various distributions.

Besides basic functionalities for querying and setting package properties,
dose3 also implements algorithms for solving more complex problems
(monitoring package evolutions, correct and complete dependency resolution,
repository-wide uninstallability checks).

%package devel
Summary: Development files for %name
Requires: %name = %EVR
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%package -n dose3-tools
Summary: Tools suite from the dose3 framework
Group: Development/ML

%description -n dose3-tools
Dose3 is a framework made of several OCaml libraries for managing
distribution packages and their dependencies.

This package contains the tools shipped with the dose3 framework
for manipulating packages of various formats.

%prep
%setup

%build
sed -i 's,oUnit,ounit2,' src/*/tests/dune
sed -i 's/stdlib-shims//' src/common/dune
%dune_build --release @install @doc
pushd doc/manpages
make man
popd

%install
%dune_install --release

mkdir -p %buildroot{%_man1dir,%_man8dir,%_man5dir}
install -m0644 doc/manpages/*.1 %buildroot%_man1dir/
install -m0644 doc/manpages/*.8 %buildroot%_man8dir/
install -m0644 doc/manpages/*.5 %buildroot%_man5dir/

%check
%dune_check

%files -f ocaml-files.runtime
%doc README.architecture COPYING

%files devel -f ocaml-files.devel
%doc COPYING

%files -n dose3-tools
%doc COPYING
%doc doc/apt-cudf/
%_man1dir/*
%_man8dir/*
%_man5dir/*
%_bindir/apt-cudf
%_bindir/dose-challenged
%_bindir/dose-ceve
%_bindir/dose-distcheck
%_bindir/dose-deb-coinstall
%_bindir/dose-outdated
%_bindir/dose-builddebcheck

%changelog
