Name: ogre
Version: 1.9.0
Release: alt4
Summary: Object-Oriented Graphics Rendering Engine
# CC-BY-SA is for devel docs
License: MIT
Group: System/Libraries
Url: http://www.ogre3d.org/
Source: %name-%version.tar
Patch: %name-%version-alt-changes.patch
Patch10: ogre-aarch64.patch
Patch11: ogre-1.9.0-armh-no-sysctl-compat.patch

BuildRequires: gcc-c++ cmake zziplib-devel libfreetype-devel libgtk+2-devel libois-devel openexr-devel cppunit-devel doxygen graphviz texi2html libtbb-devel boost-devel
BuildRequires: libXaw-devel libXrandr-devel libXau-devel libXcomposite-devel libXcursor-devel libXdmcp-devel libXinerama-devel libXi-devel libXpm-devel libXv-devel libXxf86misc-devel xorg-xf86miscproto-devel libXxf86vm-devel libXext-devel libGLU-devel libfreeimage-devel tinyxml-devel
#BuildRequires:  glew-devel 
BuildRequires: libharfbuzz-devel libGLES-devel libpoco-devel
BuildRequires: libGLEW-devel

%description
OGRE (Object-Oriented Graphics Rendering Engine) is a scene-oriented,
flexible 3D engine written in C++ designed to make it easier and more
intuitive for developers to produce applications utilising
hardware-accelerated 3D graphics. The class library abstracts all the
details of using the underlying system libraries like Direct3D and
OpenGL and provides an interface based on world objects and other
intuitive classes.

%package -n lib%name
Summary: Object-oriented Graphics Rendering Engine (libraries)
Group: System/Libraries

%description -n lib%name
Ogre is a complete object-oriented 3D rendering engine. It supports
different rendering subsystems but only the OpenGL system is useful
for Linux.

This package contains the Ogre library and plugins.

%package -n lib%name-devel
Summary: Object-oriented Graphics Rendering Engine (development files)
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Ogre is a complete object-oriented 3D rendering engine. It supports
different rendering subsystems but only the OpenGL system is useful
for Linux.

This package contains the headers needed to develop with Ogre.

%package devel-doc
Summary: Ogre development documentation
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
This package contains the Ogre API documentation and the Ogre development
manual. Install this package if you want to develop programs that use Ogre.

%package samples
Summary: Ogre samples executables and media
Group: Development/Other
Requires: %name = %EVR

%description samples
This package contains the compiled (not the source) sample applications coming
with Ogre.  It also contains some media (meshes, textures,...) needed by these
samples.

%prep
%setup -n ogre
%patch -p1
%patch10 -p1
%patch11 -p2
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -print0 -name '*.cpp' -o -name '*.hpp' -name '*.h' |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.20
%add_optflags -std=c++11
%endif
%define _cmake_skip_rpath -DCMAKE_SKIP_RPATH:BOOL=OFF
%cmake \
	-DOGRE_LIB_DIRECTORY=%_lib \
	-DOGRE_INSTALL_SAMPLES=ON \
	-DOGRE_BUILD_TESTS=ON \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DOGRE_DOCS_PATH=docs \
	%nil

%cmake_build

#Make doc
pushd Docs
    bash ./src/makedocs.sh
popd

%install
%cmakeinstall_std

# Create config for ldconfig
mkdir -p $RPM_BUILD_ROOT/etc/ld.so.conf.d
echo "%_libdir/OGRE" > $RPM_BUILD_ROOT/etc/ld.so.conf.d/%name-%_arch.conf

mkdir -p $RPM_BUILD_ROOT%_man1dir
install -p -m 644 OgreMaterialUpgrade.1 $RPM_BUILD_ROOT%_man1dir/OgreMaterialUpgrade.1
install -p -m 644 OgreMeshUpgrade.1 $RPM_BUILD_ROOT%_man1dir/OgreMeshUpgrade.1
install -p -m 644 OgreXMLConverter.1 $RPM_BUILD_ROOT%_man1dir/OgreXMLConverter.1

#Copy working samples
subst "s|/usr/lib|%_libdir|"g samples.cfg
cp -f samples.cfg $RPM_BUILD_ROOT%_datadir/OGRE/samples.cfg

%files
%doc AUTHORS BUGS COPYING
/etc/ld.so.conf.d/*
%_bindir/Ogre*
%_bindir/Test_Ogre*
%dir %_datadir/OGRE
%config(noreplace) %_datadir/OGRE/plugins.cfg
%config(noreplace) %_datadir/OGRE/quakemap.cfg
%config(noreplace) %_datadir/OGRE/resources.cfg
%config(noreplace) %_datadir/OGRE/tests.cfg
%_datadir/OGRE/Media
%_man1dir/*

%exclude %_datadir/OGRE/samples.cfg

%files -n lib%name
%dir %_libdir/OGRE
%_libdir/libOgre*.so.*
%_libdir/OGRE/*.so*

%files  -n lib%name-devel
%_libdir/libOgre*.so
%_libdir/pkgconfig/*
%_libdir/OGRE/cmake
%_includedir/OGRE

%files devel-doc
%_datadir/OGRE/docs

%files samples
%config(noreplace) %_datadir/OGRE/samples.cfg
%_bindir/SampleBrowser
%_libdir/OGRE/Samples

%changelog
